/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.coordinator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.consumer.converter.BrokerAssignmentConverter;
import org.joyqueue.client.internal.consumer.coordinator.CoordinatorManager;
import org.joyqueue.client.internal.consumer.coordinator.PartitionAssignmentManager;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignments;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignmentsHolder;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerCoordinator
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ConsumerCoordinator.class);
    private ClusterClientManager clusterClientManager;
    private PartitionAssignmentManager partitionAssignmentManager;
    private CoordinatorManager coordinatorManager;
    private Table<String, String, BrokerAssignmentsHolder> brokerAssignmentCache = HashBasedTable.create();

    public ConsumerCoordinator(ClusterClientManager clusterClientManager) {
        this.clusterClientManager = clusterClientManager;
    }

    protected void validate() throws Exception {
        this.coordinatorManager = new CoordinatorManager(this.clusterClientManager);
        this.partitionAssignmentManager = new PartitionAssignmentManager(this.clusterClientManager, this.coordinatorManager);
    }

    protected void doStart() throws Exception {
        this.coordinatorManager.start();
        this.partitionAssignmentManager.start();
    }

    protected void doStop() {
        if (this.coordinatorManager != null) {
            this.coordinatorManager.stop();
        }
        if (this.partitionAssignmentManager != null) {
            this.partitionAssignmentManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerAssignments fetchBrokerAssignment(TopicMetadata topicMetadata, String app, long sessionTimeout) {
        BrokerAssignmentsHolder brokerAssignmentsHolder = (BrokerAssignmentsHolder)this.brokerAssignmentCache.get((Object)app, (Object)topicMetadata.getTopic());
        if (brokerAssignmentsHolder != null && !brokerAssignmentsHolder.isExpired(sessionTimeout)) {
            return brokerAssignmentsHolder.getBrokerAssignments();
        }
        ConsumerCoordinator consumerCoordinator = this;
        synchronized (consumerCoordinator) {
            brokerAssignmentsHolder = (BrokerAssignmentsHolder)this.brokerAssignmentCache.get((Object)app, (Object)topicMetadata.getTopic());
            if (brokerAssignmentsHolder != null && !brokerAssignmentsHolder.isExpired(sessionTimeout)) {
                return brokerAssignmentsHolder.getBrokerAssignments();
            }
            BrokerAssignments brokerAssignments = this.partitionAssignmentManager.fetchBrokerAssignment(topicMetadata, app, sessionTimeout);
            brokerAssignmentsHolder = new BrokerAssignmentsHolder(brokerAssignments, SystemClock.now());
            this.brokerAssignmentCache.put((Object)app, (Object)topicMetadata.getTopic(), (Object)brokerAssignmentsHolder);
            if (logger.isDebugEnabled()) {
                logger.debug("update consumer assignments, app: {}, topic: {}, assignments: {}", new Object[]{app, topicMetadata.getTopic(), brokerAssignments});
            }
            return brokerAssignments;
        }
    }

    public BrokerAssignments fetchAllBrokerAssignments(TopicMetadata topicMetadata, String app) {
        return this.buildAllBrokerAssignments(topicMetadata);
    }

    public Map<String, BrokerNode> findCoordinators(List<String> topics, String app) {
        return this.coordinatorManager.findCoordinators(topics, app);
    }

    protected BrokerAssignments buildAllBrokerAssignments(TopicMetadata topicMetadata) {
        return BrokerAssignmentConverter.convertTopicAssignments(topicMetadata);
    }
}

