/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.coordinator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.client.internal.cluster.ClusterClient;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchAssignedPartitionData;
import org.joyqueue.network.command.FetchAssignedPartitionResponse;
import org.joyqueue.network.command.FindCoordinatorAckData;
import org.joyqueue.network.command.FindCoordinatorResponse;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(CoordinatorManager.class);
    private ClusterClientManager clusterClientManager;

    public CoordinatorManager(ClusterClientManager clusterClientManager) {
        this.clusterClientManager = clusterClientManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchAssignedPartitionResponse fetchAssignedPartition(BrokerNode brokerNode, String topic, String app, boolean isNearBy, long sessionTimeout) {
        try (ClusterClient client = null;){
            client = this.clusterClientManager.createClient(brokerNode);
            FetchAssignedPartitionResponse fetchAssignedPartitionResponse = client.fetchAssignedPartition(Lists.newArrayList((Object[])new FetchAssignedPartitionData[]{new FetchAssignedPartitionData(topic, (int)sessionTimeout, isNearBy)}), app);
            return fetchAssignedPartitionResponse;
        }
    }

    public BrokerNode findCoordinator(String topic, String app) {
        Map<String, BrokerNode> coordinators = this.findCoordinators(Lists.newArrayList((Object[])new String[]{topic}), app);
        if (MapUtils.isEmpty(coordinators)) {
            return null;
        }
        return coordinators.get(topic);
    }

    public Map<String, BrokerNode> findCoordinators(List<String> topics, String app) {
        FindCoordinatorResponse findCoordinatorResponse = this.clusterClientManager.getOrCreateClient().findCoordinators(topics, app);
        Map coordinators = findCoordinatorResponse.getCoordinators();
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : coordinators.entrySet()) {
            String topic = (String)entry.getKey();
            FindCoordinatorAckData findCoordinatorAckData = (FindCoordinatorAckData)entry.getValue();
            if (!findCoordinatorAckData.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                logger.error("find coordinator error, topic: {}, error: {}", (Object)topic, (Object)findCoordinatorAckData.getCode().getMessage(new Object[0]));
            }
            result.put(topic, findCoordinatorAckData.getNode());
        }
        return result;
    }
}

