/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.coordinator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.consumer.coordinator.CoordinatorManager;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignment;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignments;
import org.joyqueue.client.internal.consumer.coordinator.domain.PartitionAssignment;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchAssignedPartitionAckData;
import org.joyqueue.network.command.FetchAssignedPartitionResponse;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAssignmentManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(PartitionAssignmentManager.class);
    private ClusterClientManager clusterClientManager;
    private CoordinatorManager coordinatorManager;

    public PartitionAssignmentManager(ClusterClientManager clusterClientManager, CoordinatorManager coordinatorManager) {
        this.clusterClientManager = clusterClientManager;
        this.coordinatorManager = coordinatorManager;
    }

    public BrokerAssignments fetchBrokerAssignment(TopicMetadata topicMetadata, String app, long sessionTimeout) {
        PartitionAssignment partitionAssignment = this.fetchPartitionAssignment(topicMetadata, app, sessionTimeout);
        if (partitionAssignment == null || CollectionUtils.isEmpty(partitionAssignment.getPartitions())) {
            return new BrokerAssignments();
        }
        BrokerAssignments brokerAssignments = new BrokerAssignments();
        HashMap brokerPartitions = Maps.newHashMap();
        for (Short partition : partitionAssignment.getPartitions()) {
            PartitionMetadata partitionMetadata = topicMetadata.getPartition(partition);
            if (partitionMetadata.getLeader() == null || !partitionMetadata.getLeader().isReadable()) continue;
            List brokerPartitionList = (List)brokerPartitions.get(partitionMetadata.getLeader());
            if (brokerPartitionList == null) {
                brokerPartitionList = Lists.newLinkedList();
                brokerPartitions.put(partitionMetadata.getLeader(), brokerPartitionList);
            }
            brokerPartitionList.add(partition);
        }
        ArrayList assignments = Lists.newArrayListWithCapacity((int)brokerPartitions.size());
        for (Map.Entry brokerEntry : brokerPartitions.entrySet()) {
            assignments.add(new BrokerAssignment((BrokerNode)brokerEntry.getKey(), new PartitionAssignment((List)brokerEntry.getValue())));
        }
        brokerAssignments.setAssignments(assignments);
        return brokerAssignments;
    }

    public PartitionAssignment fetchPartitionAssignment(TopicMetadata topicMetadata, String app, long sessionTimeout) {
        try {
            BrokerNode coordinator = this.coordinatorManager.findCoordinator(topicMetadata.getTopic(), app);
            if (coordinator == null) {
                logger.warn("fetch partition assignment error, coordinator not exist, topic: {}, app: {}", (Object)topicMetadata.getTopic(), (Object)app);
                return null;
            }
            FetchAssignedPartitionResponse fetchAssignedPartitionResponse = this.coordinatorManager.fetchAssignedPartition(coordinator, topicMetadata.getTopic(), app, topicMetadata.getConsumerPolicy().getNearby(), sessionTimeout);
            FetchAssignedPartitionAckData fetchAssignedPartitionAckData = (FetchAssignedPartitionAckData)fetchAssignedPartitionResponse.getTopicPartitions().get(topicMetadata.getTopic());
            if (fetchAssignedPartitionAckData == null) {
                logger.warn("fetch partition assignment error, no partitions, topic: {}, app: {}", (Object)topicMetadata.getTopic(), (Object)app);
                return null;
            }
            if (!fetchAssignedPartitionAckData.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                logger.warn("fetch partition assignment error, topic: {}, app: {}, error: {}", new Object[]{topicMetadata.getTopic(), app, fetchAssignedPartitionAckData.getCode().getMessage(new Object[0])});
                return null;
            }
            PartitionAssignment partitionAssignment = new PartitionAssignment();
            partitionAssignment.setPartitions(fetchAssignedPartitionAckData.getPartitions());
            return partitionAssignment;
        }
        catch (Exception e) {
            logger.error("fetch partition assignment exception, topic: {}, app: {}, error: {}", new Object[]{topicMetadata.getTopic(), app, e.getMessage()});
            logger.debug("fetch partition assignment exception, topic: {}, app: {}", new Object[]{topicMetadata.getTopic(), app, e});
            return null;
        }
    }
}

