/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.domain;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.joyqueue.domain.TopicName;

public class ConsumeMessage
implements Serializable {
    private TopicName topic;
    private String app;
    private short partition;
    private long index;
    private String txId;
    private String businessId;
    private String body;
    private byte[] bodyBytes;
    private short flag;
    private byte priority;
    private long startTime;
    private byte source;
    private Map<String, String> attributes;

    public ConsumeMessage() {
    }

    public ConsumeMessage(TopicName topic, String app, short partition, long index, String txId, String businessId, String body, byte[] bodyBytes, short flag, byte priority, long startTime, byte source, Map<String, String> attributes) {
        this.topic = topic;
        this.app = app;
        this.partition = partition;
        this.index = index;
        this.txId = txId;
        this.businessId = businessId;
        this.body = body;
        this.bodyBytes = bodyBytes;
        this.flag = flag;
        this.priority = priority;
        this.startTime = startTime;
        this.source = source;
        this.attributes = attributes;
    }

    public TopicName getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public short getPartition() {
        return this.partition;
    }

    public long getIndex() {
        return this.index;
    }

    public String getTxId() {
        return this.txId;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public String getBody() {
        return this.body;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public short getFlag() {
        return this.flag;
    }

    public byte getPriority() {
        return this.priority;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public byte getSource() {
        return this.source;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return this.attributes;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public boolean containsAttribute(String key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumeMessage that = (ConsumeMessage)o;
        return this.partition == that.partition && this.index == that.index && Objects.equal((Object)this.topic, (Object)that.topic);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topic, this.partition, this.index});
    }

    public String toString() {
        return "ConsumeMessage{topic=" + this.topic + ", app='" + this.app + '\'' + ", partition=" + this.partition + ", index=" + this.index + ", txId='" + this.txId + '\'' + ", businessId='" + this.businessId + '\'' + ", flag='" + this.flag + '\'' + '}';
    }
}

