/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.interceptor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.nameserver.NameServerConfig;

public class ConsumeContext {
    private String topic;
    private String app;
    private NameServerConfig nameserver;
    private List<ConsumeMessage> messages;
    private Map<Object, Object> attributes;
    private Set<ConsumeMessage> messageFilter;

    public ConsumeContext(String topic, String app, NameServerConfig nameserver, List<ConsumeMessage> messages) {
        this.topic = topic;
        this.app = app;
        this.nameserver = nameserver;
        this.messages = messages;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public NameServerConfig getNameserver() {
        return this.nameserver;
    }

    public List<ConsumeMessage> getMessages() {
        return this.messages;
    }

    public Set<ConsumeMessage> getMessageFilter() {
        return this.messageFilter;
    }

    public void filterMessage(ConsumeMessage message) {
        if (this.messageFilter == null) {
            this.messageFilter = Sets.newHashSet();
        }
        this.messageFilter.add(message);
    }

    public boolean isFilteredMessage(ConsumeMessage message) {
        if (this.messageFilter == null) {
            return false;
        }
        return this.messageFilter.contains(message);
    }

    public List<ConsumeMessage> getFilteredMessages() {
        if (this.messageFilter == null) {
            return this.messages;
        }
        HashSet filteredMessages = Sets.newHashSet(this.messages);
        for (ConsumeMessage consumeMessage : this.messageFilter) {
            filteredMessages.remove(consumeMessage);
        }
        return Lists.newArrayList((Iterable)filteredMessages);
    }

    public <T> T getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return (T)this.attributes.get(key);
    }

    public boolean removeAttribute(Object key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.remove(key) != null;
    }

    public boolean putAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = Maps.newLinkedHashMap();
        }
        return this.attributes.put(key, value) == null;
    }

    public boolean containsAttribute(Object key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(key);
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }
}

