/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.interceptor;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.client.internal.common.ordered.OrderedSorter;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptor;
import org.joyqueue.client.internal.consumer.interceptor.GlobalConsumerInterceptorManager;

public class ConsumerInterceptorManager {
    private List<ConsumerInterceptor> interceptors = Lists.newLinkedList();
    private List<ConsumerInterceptor> sortedInterceptors;

    public List<ConsumerInterceptor> getSortedInterceptors() {
        if (this.sortedInterceptors != null) {
            return this.sortedInterceptors;
        }
        LinkedList sortedInterceptors = Lists.newLinkedList();
        sortedInterceptors.addAll(GlobalConsumerInterceptorManager.getInterceptors());
        sortedInterceptors.addAll(this.interceptors);
        OrderedSorter.sort(sortedInterceptors);
        this.sortedInterceptors = sortedInterceptors;
        return sortedInterceptors;
    }

    public void addInterceptor(ConsumerInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.sortedInterceptors = null;
    }

    public void removeInterceptor(ConsumerInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.sortedInterceptors = null;
    }
}

