/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.interceptor;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.interceptor.ConsumeContext;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptor;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptorManager;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInvoker;
import org.joyqueue.client.internal.nameserver.NameServerConfig;

public class ConsumerInvocation {
    private ConsumerConfig config;
    private String topic;
    private NameServerConfig nameServerConfig;
    private List<ConsumeMessage> messages;
    private ConsumerInterceptorManager consumerInterceptorManager;
    private ConsumerInvoker consumerInvoker;

    public ConsumerInvocation(ConsumerConfig config, String topic, NameServerConfig nameServerConfig, List<ConsumeMessage> messages, ConsumerInterceptorManager consumerInterceptorManager, ConsumerInvoker consumerInvoker) {
        this.config = config;
        this.topic = topic;
        this.nameServerConfig = nameServerConfig;
        this.messages = messages;
        this.consumerInterceptorManager = consumerInterceptorManager;
        this.consumerInvoker = consumerInvoker;
    }

    public List<ConsumeReply> invoke() {
        ConsumeContext context = new ConsumeContext(this.topic, this.config.getApp(), this.nameServerConfig, Collections.unmodifiableList(this.messages));
        List<ConsumerInterceptor> interceptors = this.consumerInterceptorManager.getSortedInterceptors();
        if (CollectionUtils.isEmpty(interceptors)) {
            return this.consumerInvoker.invoke(context);
        }
        boolean isRejected = false;
        for (ConsumerInterceptor interceptor : interceptors) {
            if (interceptor.preConsume(context)) continue;
            isRejected = true;
        }
        if (isRejected) {
            return this.consumerInvoker.reject(context);
        }
        List<ConsumeReply> result = this.consumerInvoker.invoke(context);
        for (ConsumerInterceptor interceptor : interceptors) {
            interceptor.postConsume(context, result);
        }
        return result;
    }
}

