/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.consumer.BatchMessageListener;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.converter.ConsumeMessageConverter;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.exception.IgnoreAckException;
import org.joyqueue.client.internal.consumer.interceptor.ConsumeContext;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInvoker;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.domain.ConsumerPolicy;
import org.joyqueue.network.command.RetryType;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchConsumerInvoker
implements ConsumerInvoker {
    protected static final Logger logger = LoggerFactory.getLogger(BatchConsumerInvoker.class);
    private ConsumerConfig config;
    private TopicMetadata topicMetadata;
    private ConsumerPolicy consumerPolicy;
    private List<ConsumeMessage> messages;
    private List<BatchMessageListener> listeners;

    public BatchConsumerInvoker(ConsumerConfig config, TopicMetadata topicMetadata, ConsumerPolicy consumerPolicy, List<ConsumeMessage> messages, List<BatchMessageListener> listeners) {
        this.config = config;
        this.topicMetadata = topicMetadata;
        this.consumerPolicy = consumerPolicy;
        this.messages = messages;
        this.listeners = listeners;
    }

    @Override
    public List<ConsumeReply> invoke(ConsumeContext context) {
        List<ConsumeMessage> filteredMessage = context.getFilteredMessages();
        if (CollectionUtils.isEmpty(filteredMessage)) {
            return ConsumeMessageConverter.convertToReply(this.messages, RetryType.NONE);
        }
        long ackTimeout = this.config.getAckTimeout() != -1L ? this.config.getAckTimeout() : (long)this.consumerPolicy.getAckTimeout().intValue();
        RetryType retryType = RetryType.NONE;
        try {
            long startTime = SystemClock.now();
            for (BatchMessageListener listener : this.listeners) {
                listener.onMessage(filteredMessage);
            }
            long endTime = SystemClock.now();
            if (endTime - startTime > ackTimeout) {
                logger.warn("execute batchMessageListener timeout, topic: {}, messages: {}, listeners: {}", new Object[]{this.topicMetadata.getTopic(), this.messages, this.listeners});
                retryType = RetryType.NONE;
            }
        }
        catch (Exception e) {
            if (e instanceof IgnoreAckException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("execute batchMessageListener, ignore ack, topic: {}, messages: {}, listeners: {}", new Object[]{this.topicMetadata.getTopic(), this.messages, this.listeners});
                }
                retryType = RetryType.OTHER;
            }
            logger.error("execute batchMessageListener exception, topic: {}, messages: {}, listeners: {}", new Object[]{this.topicMetadata.getTopic(), this.messages, this.listeners, e});
            retryType = RetryType.EXCEPTION;
        }
        return ConsumeMessageConverter.convertToReply(this.messages, retryType);
    }

    @Override
    public List<ConsumeReply> reject(ConsumeContext context) {
        logger.info("reject execute batchListener, topic: {}, messages: {}", (Object)this.topicMetadata.getTopic(), this.messages);
        return ConsumeMessageConverter.convertToReply(this.messages, RetryType.NONE);
    }
}

