/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.MessagePoller;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.client.internal.consumer.support.DefaultConsumerIndexManager;
import org.joyqueue.client.internal.consumer.support.LocalConsumerIndexManager;
import org.joyqueue.client.internal.consumer.support.PartitionMessagePoller;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;

public class BroadcastMessagePoller
extends Service
implements MessagePoller {
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ConsumerClientManager consumerClientManager;
    private LocalConsumerIndexManager consumerIndexManager;
    private PartitionMessagePoller delegate;

    public BroadcastMessagePoller(ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ConsumerClientManager consumerClientManager) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getBroadcastGroup()), (Object)"consumer.broadcastGroup must be greater than 0");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getBroadcastLocalPath()), (Object)"consumer.broadcastLocalPath must not be null");
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.consumerClientManager = consumerClientManager;
    }

    protected void validate() throws Exception {
        this.consumerIndexManager = new LocalConsumerIndexManager(this.config, new DefaultConsumerIndexManager(this.clusterManager, this.consumerClientManager));
        this.delegate = new PartitionMessagePoller(this.config, this.nameServerConfig, this.clusterManager, this.consumerClientManager, this.consumerIndexManager);
    }

    protected void doStart() throws Exception {
        this.consumerIndexManager.start();
        this.delegate.start();
    }

    protected void doStop() {
        if (this.consumerIndexManager != null) {
            this.consumerIndexManager.stop();
        }
        this.delegate.stop();
    }

    @Override
    public ConsumeMessage pollOnce(String topic) {
        return this.delegate.pollOnce(topic);
    }

    @Override
    public ConsumeMessage pollOnce(String topic, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollOnce(topic, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> poll(String topic) {
        return this.delegate.poll(topic);
    }

    @Override
    public List<ConsumeMessage> poll(String topic, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.poll(topic, timeout, timeoutUnit);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition) {
        return this.delegate.pollPartitionOnce(topic, partition);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionOnce(topic, partition, timeout, timeoutUnit);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long index) {
        return this.delegate.pollPartitionOnce(topic, partition, index);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionOnce(topic, partition, index, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition) {
        return this.delegate.pollPartition(topic, partition);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartition(topic, partition, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long index) {
        return this.delegate.pollPartition(topic, partition, index);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartition(topic, partition, index, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition) {
        return this.delegate.pollPartitionAsync(topic, partition);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionAsync(topic, partition, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long index) {
        return this.delegate.pollPartitionAsync(topic, partition, index);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionAsync(topic, partition, index, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(String topic) {
        return this.delegate.pollAsync(topic);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(String topic, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollAsync(topic, timeout, timeoutUnit);
    }

    @Override
    public JoyQueueCode reply(String topic, List<ConsumeReply> replyList) {
        return this.delegate.reply(topic, replyList);
    }

    @Override
    public JoyQueueCode replyOnce(String topic, ConsumeReply reply) {
        return this.delegate.replyOnce(topic, reply);
    }

    @Override
    public FetchIndexData fetchIndex(String topic, short partition) {
        return this.delegate.fetchIndex(topic, partition);
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        return this.delegate.getTopicMetadata(topic);
    }
}

