/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.client.internal.Plugins;
import org.joyqueue.client.internal.consumer.BrokerLoadBalance;

public class BrokerLoadBalanceManager {
    private ConcurrentMap<String, BrokerLoadBalance> brokerLoadBalanceMap = Maps.newConcurrentMap();

    public BrokerLoadBalance getBrokerLoadBalance(String topic, String loadBalanceType) {
        BrokerLoadBalance oldBrokerLoadBalance;
        BrokerLoadBalance brokerLoadBalance = (BrokerLoadBalance)this.brokerLoadBalanceMap.get(topic);
        if (brokerLoadBalance == null && (oldBrokerLoadBalance = this.brokerLoadBalanceMap.putIfAbsent(topic, brokerLoadBalance = this.create(loadBalanceType))) != null) {
            brokerLoadBalance = oldBrokerLoadBalance;
        }
        return brokerLoadBalance;
    }

    private BrokerLoadBalance create(String loadBalanceType) {
        BrokerLoadBalance loadBalance = (BrokerLoadBalance)Plugins.LOADBALANCE.get((Object)loadBalanceType);
        Preconditions.checkArgument((loadBalance != null ? 1 : 0) != 0, (Object)String.format("no balance found. type: %s", loadBalanceType));
        return loadBalance;
    }
}

