/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.consumer.domain.LocalIndexData;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerLocalIndexStore
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ConsumerLocalIndexStore.class);
    private String persistPath;
    private int persistInterval;
    private File persistFile;
    private volatile boolean isNeedPersist;
    private ScheduledExecutorService persistTimer;
    private Table<String, String, Map<Short, LocalIndexData>> indexTable;

    public ConsumerLocalIndexStore(String persistPath, int persistInterval) {
        this.persistPath = persistPath;
        this.persistInterval = persistInterval;
    }

    protected void validate() throws Exception {
        this.persistFile = this.initPersistPathFile(this.persistPath);
        this.indexTable = this.doRead(this.persistFile);
        this.persistTimer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("joyqueue-consumer-local-index-persist"));
    }

    protected void doStart() throws Exception {
        this.persistTimer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ConsumerLocalIndexStore.this.persist();
            }
        }, this.persistInterval, this.persistInterval, TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        if (this.persistTimer != null) {
            this.persistTimer.shutdown();
        }
    }

    public LocalIndexData fetchIndex(String topic, String app, short partition) {
        Map partitionMap = (Map)this.indexTable.get((Object)app, (Object)topic);
        if (partitionMap == null) {
            return null;
        }
        return (LocalIndexData)partitionMap.get(partition);
    }

    public boolean saveIndex(String topic, String app, short partition, long index) {
        LocalIndexData localIndexData;
        long now = SystemClock.now();
        Map partitionMap = (Map)this.indexTable.get((Object)app, (Object)topic);
        if (partitionMap == null) {
            partitionMap = Maps.newHashMap();
            this.indexTable.put((Object)app, (Object)topic, (Object)partitionMap);
        }
        if ((localIndexData = (LocalIndexData)partitionMap.get(partition)) == null) {
            localIndexData = new LocalIndexData();
            localIndexData.setCreateTime(now);
            partitionMap.put(partition, localIndexData);
        }
        localIndexData.setIndex(index);
        localIndexData.setUpdateTime(now);
        this.isNeedPersist = true;
        return true;
    }

    protected File initPersistPathFile(String path) throws Exception {
        File persistFile = new File(path);
        if (persistFile.isDirectory()) {
            throw new IllegalArgumentException("local index store path is not directory");
        }
        if (!persistFile.exists()) {
            persistFile.getParentFile().mkdirs();
            persistFile.createNewFile();
        }
        return persistFile;
    }

    protected Table<String, String, Map<Short, LocalIndexData>> doRead(File persistFile) throws Exception {
        String json = FileUtils.readFileToString((File)persistFile);
        HashBasedTable result = HashBasedTable.create();
        if (StringUtils.isBlank((CharSequence)json)) {
            return result;
        }
        Gson gson = new GsonBuilder().create();
        Map map = (Map)gson.fromJson(json, Map.class);
        for (Map.Entry appEntry : map.entrySet()) {
            String app = (String)appEntry.getKey();
            for (Map.Entry topicEntry : ((Map)appEntry.getValue()).entrySet()) {
                String topic = (String)topicEntry.getKey();
                HashMap partitions = Maps.newHashMap();
                for (Map.Entry partitionEntry : ((Map)topicEntry.getValue()).entrySet()) {
                    short partition = Short.valueOf((String)partitionEntry.getKey());
                    Map values = (Map)partitionEntry.getValue();
                    long index = Double.valueOf(String.valueOf(values.get("index"))).longValue();
                    long updateTime = Double.valueOf(String.valueOf(values.get("updateTime"))).longValue();
                    long createTime = Double.valueOf(String.valueOf(values.get("createTime"))).longValue();
                    partitions.put(partition, new LocalIndexData(index, updateTime, createTime));
                }
                result.put((Object)app, (Object)topic, (Object)partitions);
            }
        }
        return result;
    }

    protected void persist() {
        if (!this.isNeedPersist) {
            return;
        }
        this.doPersist(this.persistFile);
        this.isNeedPersist = false;
    }

    protected void doPersist(File persistFile) {
        String json = new GsonBuilder().create().toJson((Object)this.indexTable.rowMap());
        try {
            FileUtils.writeStringToFile((File)persistFile, (String)json);
        }
        catch (Exception e) {
            logger.error("write local index error, file: {}", (Object)persistFile, (Object)e);
        }
    }
}

