/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.ConsumerIndexManager;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.client.internal.consumer.transport.ConsumerClient;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.CommitAckData;
import org.joyqueue.network.command.CommitAckResponse;
import org.joyqueue.network.command.FetchIndexResponse;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumerIndexManager
extends Service
implements ConsumerIndexManager {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultConsumerIndexManager.class);
    private ClusterManager clusterManager;
    private ConsumerClientManager consumerClientManager;

    public DefaultConsumerIndexManager(ClusterManager clusterManager, ConsumerClientManager consumerClientManager) {
        this.clusterManager = clusterManager;
        this.consumerClientManager = consumerClientManager;
    }

    @Override
    public JoyQueueCode resetIndex(String topic, String app, short partition, long timeout) {
        return JoyQueueCode.SUCCESS;
    }

    @Override
    public FetchIndexData fetchIndex(String topic, String app, short partition, long timeout) {
        HashMap topicMap = Maps.newHashMap();
        topicMap.put(topic, Lists.newArrayList((Object[])new Short[]{partition}));
        Table<String, Short, FetchIndexData> batchFetchIndexResult = this.batchFetchIndex(topicMap, app, timeout);
        return (FetchIndexData)batchFetchIndexResult.get((Object)topic, (Object)partition);
    }

    @Override
    public JoyQueueCode commitReply(String topic, List<ConsumeReply> replyList, String app, long timeout) {
        HashMap topicMap = Maps.newHashMap();
        topicMap.put(topic, replyList);
        Map<String, JoyQueueCode> batchCommitReplyResult = this.batchCommitReply(topicMap, app, timeout);
        return batchCommitReplyResult.get(topic);
    }

    @Override
    public Table<String, Short, FetchIndexData> batchFetchIndex(Map<String, List<Short>> topicMap, String app, long timeout) {
        HashBasedTable result = HashBasedTable.create();
        if (MapUtils.isEmpty(topicMap)) {
            return result;
        }
        Map<BrokerNode, Map<String, List<Short>>> brokerFetchMap = this.buildFetchIndexParams(topicMap, app);
        for (Map.Entry<BrokerNode, Map<String, List<Short>>> entry : brokerFetchMap.entrySet()) {
            try {
                ConsumerClient client = this.consumerClientManager.getOrCreateClient(entry.getKey());
                FetchIndexResponse fetchIndexResponse = client.fetchIndex(entry.getValue(), app, timeout);
                for (Map.Entry topicEntry : fetchIndexResponse.getData().rowMap().entrySet()) {
                    for (Map.Entry partitionEntry : ((Map)topicEntry.getValue()).entrySet()) {
                        org.joyqueue.network.command.FetchIndexData value = (org.joyqueue.network.command.FetchIndexData)partitionEntry.getValue();
                        result.put(topicEntry.getKey(), partitionEntry.getKey(), (Object)new FetchIndexData(value.getIndex(), value.getLeftIndex(), value.getRightIndex(), value.getCode()));
                    }
                }
            }
            catch (ClientException e) {
                logger.error("fetchIndex exception, fetchMap: {}, app: {}", new Object[]{entry.getValue(), app, e});
                for (Map.Entry entry2 : entry.getValue().entrySet()) {
                    for (Short partition : (List)entry2.getValue()) {
                        result.put(entry2.getKey(), (Object)partition, (Object)new FetchIndexData(JoyQueueCode.valueOf((int)e.getCode())));
                    }
                }
            }
        }
        for (Map.Entry<Object, Object> entry : topicMap.entrySet()) {
            for (Short partition : (List)entry.getValue()) {
                if (result.contains(entry.getKey(), (Object)partition)) continue;
                result.put(entry.getKey(), (Object)partition, (Object)new FetchIndexData(JoyQueueCode.CN_UNKNOWN_ERROR));
            }
        }
        return result;
    }

    @Override
    public Map<String, JoyQueueCode> batchCommitReply(Map<String, List<ConsumeReply>> replyMap, String app, long timeout) {
        HashMap result = Maps.newHashMap();
        Map<BrokerNode, Table<String, Short, List<CommitAckData>>> brokerCommitMap = this.buildCommitAckParams(replyMap, app);
        for (Map.Entry<BrokerNode, Table<String, Short, List<CommitAckData>>> entry : brokerCommitMap.entrySet()) {
            try {
                ConsumerClient client = this.consumerClientManager.getOrCreateClient(entry.getKey());
                CommitAckResponse commitAckResponse = client.commitAck(entry.getValue(), app, timeout);
                for (Map.Entry resultEntry : commitAckResponse.getResult().rowMap().entrySet()) {
                    for (Map.Entry ackEntry : ((Map)resultEntry.getValue()).entrySet()) {
                        result.put(resultEntry.getKey(), ackEntry.getValue());
                    }
                }
            }
            catch (ClientException e) {
                logger.error("commit ack exception, commitMap: {}, app: {}", new Object[]{entry.getValue(), app, e});
                for (Map.Entry topicEntry : entry.getValue().rowMap().entrySet()) {
                    result.put(topicEntry.getKey(), JoyQueueCode.valueOf((int)e.getCode()));
                }
            }
        }
        for (Map.Entry<Object, Object> entry : replyMap.entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), JoyQueueCode.CN_UNKNOWN_ERROR);
        }
        return result;
    }

    protected Map<BrokerNode, Map<String, List<Short>>> buildFetchIndexParams(Map<String, List<Short>> topicMap, String app) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<Short>> entry : topicMap.entrySet()) {
            String topic = entry.getKey();
            TopicMetadata topicMetadata = this.clusterManager.fetchTopicMetadata(topic, app);
            if (topicMetadata == null) {
                logger.warn("topic {} metadata is null", (Object)topic);
                continue;
            }
            for (Short partition : entry.getValue()) {
                List partitions;
                BrokerNode leader;
                PartitionMetadata partitionMetadata = topicMetadata.getPartition(partition);
                if (partitionMetadata == null) {
                    partitionMetadata = topicMetadata.getPartitions().get(0);
                }
                if ((leader = partitionMetadata.getLeader()) == null) {
                    logger.warn("topic {}, partition {}, leader is null", (Object)topic, (Object)partition);
                    continue;
                }
                Map topicPartitionMap = (Map)result.get(leader);
                if (topicPartitionMap == null) {
                    topicPartitionMap = Maps.newHashMap();
                    result.put(leader, topicPartitionMap);
                }
                if ((partitions = (List)topicPartitionMap.get(topic)) == null) {
                    partitions = Lists.newLinkedList();
                    topicPartitionMap.put(topic, partitions);
                }
                partitions.add(partition);
            }
        }
        return result;
    }

    protected Map<BrokerNode, Table<String, Short, List<CommitAckData>>> buildCommitAckParams(Map<String, List<ConsumeReply>> ackMap, String app) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<ConsumeReply>> entry : ackMap.entrySet()) {
            String topic = entry.getKey();
            TopicMetadata topicMetadata = this.clusterManager.fetchTopicMetadata(topic, app);
            if (topicMetadata == null) {
                logger.warn("topic {} metadata is null", (Object)topic);
                continue;
            }
            for (ConsumeReply consumeReply : entry.getValue()) {
                List commitAckList;
                BrokerNode leader;
                PartitionMetadata partitionMetadata = topicMetadata.getPartition(consumeReply.getPartition());
                if (partitionMetadata == null) {
                    partitionMetadata = topicMetadata.getPartitions().get(0);
                }
                if ((leader = partitionMetadata.getLeader()) == null) {
                    logger.warn("topic {}, partition {}, leader is null", (Object)topic, (Object)consumeReply.getPartition());
                    continue;
                }
                Table topicConsumeAckTable = (Table)result.get(leader);
                if (topicConsumeAckTable == null) {
                    topicConsumeAckTable = HashBasedTable.create();
                    result.put(leader, topicConsumeAckTable);
                }
                if ((commitAckList = (List)topicConsumeAckTable.get((Object)topic, (Object)consumeReply.getPartition())) == null) {
                    commitAckList = Lists.newLinkedList();
                    topicConsumeAckTable.put((Object)topic, (Object)consumeReply.getPartition(), (Object)commitAckList);
                }
                commitAckList.add(new CommitAckData(consumeReply.getPartition(), consumeReply.getIndex(), consumeReply.getRetryType()));
            }
        }
        return result;
    }
}

