/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BaseMessageListener;
import org.joyqueue.client.internal.consumer.BatchMessageListener;
import org.joyqueue.client.internal.consumer.MessageConsumer;
import org.joyqueue.client.internal.consumer.MessageListener;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.client.internal.consumer.exception.ConsumerException;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptor;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptorManager;
import org.joyqueue.client.internal.consumer.support.TopicMessageConsumer;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageConsumer
extends Service
implements MessageConsumer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMessageConsumer.class);
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ClusterClientManager clusterClientManager;
    private ConsumerClientManager consumerClientManager;
    private String subscribeTopic;
    private TopicMessageConsumer topicMessageConsumer;
    private ConsumerInterceptorManager consumerInterceptorManager = new ConsumerInterceptorManager();

    public DefaultMessageConsumer(ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ClusterClientManager clusterClientManager, ConsumerClientManager consumerClientManager) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config not null");
        Preconditions.checkArgument((nameServerConfig != null ? 1 : 0) != 0, (Object)"nameserver not null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager not null");
        Preconditions.checkArgument((clusterClientManager != null ? 1 : 0) != 0, (Object)"clusterClientManager not null");
        Preconditions.checkArgument((consumerClientManager != null ? 1 : 0) != 0, (Object)"consumerClientManager not null");
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.clusterClientManager = clusterClientManager;
        this.consumerClientManager = consumerClientManager;
    }

    protected void doStart() throws Exception {
        if (this.topicMessageConsumer != null) {
            this.topicMessageConsumer.start();
        }
    }

    protected void doStop() {
        if (this.topicMessageConsumer != null) {
            this.topicMessageConsumer.stop();
        }
    }

    @Override
    public synchronized void subscribe(String topic) {
        TopicMessageConsumer topicMessageConsumer;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic can not be null");
        this.checkUnsubscribe();
        this.topicMessageConsumer = topicMessageConsumer = this.newTopicMessageConsumer(topic);
        this.subscribeTopic = topic;
    }

    @Override
    public void unsubscribe() {
        this.checkSubscribe();
        this.subscribeTopic = null;
        if (this.isStarted()) {
            this.topicMessageConsumer.stop();
        }
    }

    @Override
    public String subscription() {
        return this.subscribeTopic;
    }

    @Override
    public boolean isSubscribed() {
        return StringUtils.isNotBlank((CharSequence)this.subscribeTopic);
    }

    @Override
    public synchronized void subscribe(String topic, MessageListener messageListener) {
        this.doSubscribeListener(topic, messageListener);
    }

    @Override
    public synchronized void subscribeBatch(String topic, BatchMessageListener batchMessageListener) {
        this.doSubscribeListener(topic, batchMessageListener);
    }

    protected void doSubscribeListener(String topic, BaseMessageListener messageListener) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic can not be null");
        Preconditions.checkArgument((messageListener != null ? 1 : 0) != 0, (Object)"listener can not be null");
        this.checkUnsubscribe();
        TopicMessageConsumer topicMessageConsumer = this.newTopicMessageConsumer(topic);
        topicMessageConsumer.addListener(messageListener);
        this.topicMessageConsumer = topicMessageConsumer;
        this.subscribeTopic = topic;
    }

    protected TopicMessageConsumer newTopicMessageConsumer(String topic) {
        TopicMessageConsumer topicMessageConsumer = new TopicMessageConsumer(topic, this.config, this.nameServerConfig, this.clusterManager, this.clusterClientManager, this.consumerClientManager, this.consumerInterceptorManager);
        try {
            if (this.isStarted()) {
                topicMessageConsumer.start();
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug("newTopicMessageConsumer exception, topic: {}", (Object)topic, (Object)e);
            throw e;
        }
        catch (ClientException e) {
            logger.debug("newTopicMessageConsumer exception, topic: {}", (Object)topic, (Object)e);
            throw new ConsumerException(e.getMessage(), e.getCode(), e);
        }
        catch (Exception e) {
            logger.debug("newTopicMessageConsumer exception, topic: {}", (Object)topic, (Object)e);
            throw new ConsumerException(JoyQueueCode.CN_UNKNOWN_ERROR.getMessage(new Object[0]), JoyQueueCode.CN_UNKNOWN_ERROR.getCode(), e);
        }
        return topicMessageConsumer;
    }

    @Override
    public void resumeListen() {
        this.checkState();
        this.checkSubscribe();
        this.topicMessageConsumer.resume();
    }

    @Override
    public void suspendListen() {
        this.checkState();
        this.checkSubscribe();
        this.topicMessageConsumer.suspend();
    }

    @Override
    public boolean isListenSuspended() {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.isSuspend();
    }

    @Override
    public synchronized void addInterceptor(ConsumerInterceptor interceptor) {
        Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
        this.consumerInterceptorManager.addInterceptor(interceptor);
    }

    @Override
    public synchronized void removeInterceptor(ConsumerInterceptor interceptor) {
        Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
        this.consumerInterceptorManager.removeInterceptor(interceptor);
    }

    @Override
    public ConsumeMessage pollOnce() {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollOnce(this.subscribeTopic);
    }

    @Override
    public ConsumeMessage pollOnce(long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollOnce(this.subscribeTopic, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> poll() {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().poll(this.subscribeTopic);
    }

    @Override
    public List<ConsumeMessage> poll(long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().poll(this.subscribeTopic, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync() {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollAsync(this.subscribeTopic);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollAsync(this.subscribeTopic, timeout, timeoutUnit);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionOnce(this.subscribeTopic, partition);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionOnce(this.subscribeTopic, partition, timeout, timeoutUnit);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition, long index) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionOnce(this.subscribeTopic, partition, index);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition, long index, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionOnce(this.subscribeTopic, partition, index, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartition(this.subscribeTopic, partition);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartition(this.subscribeTopic, partition, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionAsync(this.subscribeTopic, partition);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionAsync(this.subscribeTopic, partition, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition, long index) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartition(this.subscribeTopic, partition, index);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition, long index, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartition(this.subscribeTopic, partition, index, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition, long index) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionAsync(this.subscribeTopic, partition, index);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition, long index, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().pollPartitionAsync(this.subscribeTopic, partition, index, timeout, timeoutUnit);
    }

    @Override
    public JoyQueueCode reply(List<ConsumeReply> replyList) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(replyList), (Object)"replyList can not be null");
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().reply(this.subscribeTopic, replyList);
    }

    @Override
    public JoyQueueCode replyOnce(ConsumeReply reply) {
        Preconditions.checkArgument((reply != null ? 1 : 0) != 0, (Object)"replyList can not be null");
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().replyOnce(this.subscribeTopic, reply);
    }

    @Override
    public FetchIndexData fetchIndex(short partition) {
        this.checkState();
        this.checkSubscribe();
        return this.topicMessageConsumer.getMessagePoller().fetchIndex(this.subscribeTopic, partition);
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        String topicFullName = NameServerHelper.getTopicFullName(topic, this.nameServerConfig);
        return this.clusterManager.fetchTopicMetadata(topicFullName, this.config.getAppFullName());
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new ConsumerException("consumer is not started", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }

    protected void checkSubscribe() {
        if (StringUtils.isBlank((CharSequence)this.subscribeTopic)) {
            throw new ConsumerException("consumer not subscribe topic", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }

    protected void checkUnsubscribe() {
        if (StringUtils.isNotBlank((CharSequence)this.subscribeTopic)) {
            throw new ConsumerException("consumer is subscribed topic", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }
}

