/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joyqueue.client.internal.consumer.MessageFetcher;
import org.joyqueue.client.internal.consumer.callback.BatchFetchListener;
import org.joyqueue.client.internal.consumer.callback.BatchPartitionFetchListener;
import org.joyqueue.client.internal.consumer.callback.FetchListener;
import org.joyqueue.client.internal.consumer.callback.PartitionFetchListener;
import org.joyqueue.client.internal.consumer.config.FetcherConfig;
import org.joyqueue.client.internal.consumer.converter.BrokerMessageConverter;
import org.joyqueue.client.internal.consumer.domain.FetchMessageData;
import org.joyqueue.client.internal.consumer.transport.ConsumerClient;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientGroup;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.transport.ConnectionState;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchPartitionMessageAckData;
import org.joyqueue.network.command.FetchPartitionMessageResponse;
import org.joyqueue.network.command.FetchTopicMessageResponse;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageFetcher
extends Service
implements MessageFetcher {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMessageFetcher.class);
    private FetcherConfig config;
    private ConsumerClientManager consumerClientManager;
    private ConnectionState connectionState = new ConnectionState();

    public DefaultMessageFetcher(ConsumerClientManager consumerClientManager, FetcherConfig config) {
        Preconditions.checkArgument((consumerClientManager != null ? 1 : 0) != 0, (Object)"consumerClientManager not null");
        this.consumerClientManager = consumerClientManager;
        this.config = config;
    }

    @Override
    public FetchMessageData fetch(BrokerNode brokerNode, String topic, String app, int count, long timeout, long ackTimeout, long longPollTimeout) {
        Map<String, FetchMessageData> fetchMessageMap = this.batchFetch(brokerNode, Lists.newArrayList((Object[])new String[]{topic}), app, count, timeout, ackTimeout, longPollTimeout);
        return fetchMessageMap.get(topic);
    }

    @Override
    public void asyncFetch(BrokerNode brokerNode, final String topic, String app, int count, long timeout, long ackTimeout, long longPollTimeout, final FetchListener listener) {
        this.batchFetchAsync(brokerNode, Lists.newArrayList((Object[])new String[]{topic}), app, count, timeout, ackTimeout, longPollTimeout, new BatchFetchListener(){

            @Override
            public void onMessage(Map<String, FetchMessageData> fetchMessageMap) {
                FetchMessageData fetchMessageData = fetchMessageMap.get(topic);
                listener.onMessage(fetchMessageData);
            }

            @Override
            public void onException(Throwable cause) {
                listener.onException(cause);
            }
        });
    }

    @Override
    public FetchMessageData fetchPartition(BrokerNode brokerNode, String topic, String app, short partition, int count, long timeout) {
        HashMap partitions = Maps.newHashMap();
        partitions.put(topic, partition);
        Table<String, Short, FetchMessageData> fetchMessageTable = this.batchFetchPartitions(brokerNode, partitions, app, count, timeout);
        return (FetchMessageData)fetchMessageTable.get((Object)topic, (Object)partition);
    }

    @Override
    public void fetchPartitionAsync(BrokerNode brokerNode, final String topic, String app, final short partition, int count, long timeout, final PartitionFetchListener listener) {
        HashMap partitions = Maps.newHashMap();
        partitions.put(topic, partition);
        this.batchFetchPartitionsAsync(brokerNode, partitions, app, count, timeout, new BatchPartitionFetchListener(){

            @Override
            public void onMessage(Table<String, Short, FetchMessageData> fetchMessageTable) {
                FetchMessageData fetchMessageData = (FetchMessageData)fetchMessageTable.get((Object)topic, (Object)partition);
                listener.onMessage(fetchMessageData);
            }

            @Override
            public void onException(Throwable cause) {
                listener.onException(cause);
            }
        });
    }

    @Override
    public FetchMessageData fetchPartition(BrokerNode brokerNode, String topic, String app, short partition, long index, int count, long timeout) {
        HashBasedTable partitionTable = HashBasedTable.create();
        partitionTable.put((Object)topic, (Object)partition, (Object)index);
        Table<String, Short, FetchMessageData> fetchMessageTable = this.batchFetchPartitions(brokerNode, (Table<String, Short, Long>)partitionTable, app, count, timeout);
        return (FetchMessageData)fetchMessageTable.get((Object)topic, (Object)partition);
    }

    @Override
    public void fetchPartitionAsync(BrokerNode brokerNode, final String topic, String app, final short partition, long index, int count, long timeout, final PartitionFetchListener listener) {
        HashBasedTable partitionTable = HashBasedTable.create();
        partitionTable.put((Object)topic, (Object)partition, (Object)index);
        this.batchFetchPartitionsAsync(brokerNode, (Table<String, Short, Long>)partitionTable, app, count, timeout, new BatchPartitionFetchListener(){

            @Override
            public void onMessage(Table<String, Short, FetchMessageData> fetchMessageTable) {
                FetchMessageData fetchMessageData = (FetchMessageData)fetchMessageTable.get((Object)topic, (Object)partition);
                listener.onMessage(fetchMessageData);
            }

            @Override
            public void onException(Throwable cause) {
                listener.onException(cause);
            }
        });
    }

    @Override
    public Map<String, FetchMessageData> batchFetch(BrokerNode brokerNode, List<String> topics, String app, int count, long timeout, long ackTimeout, long longPollTimeout) {
        this.checkState();
        ConsumerClient client = this.consumerClientManager.getOrCreateClient(brokerNode);
        this.handleAddConsumers(brokerNode, topics, app, client);
        FetchTopicMessageResponse fetchTopicMessageResponse = client.fetchTopicMessage(topics, app, count, timeout, ackTimeout, longPollTimeout);
        return BrokerMessageConverter.convert(app, fetchTopicMessageResponse.getData());
    }

    @Override
    public void batchFetchAsync(BrokerNode brokerNode, List<String> topics, final String app, int count, long timeout, long ackTimeout, long longPollTimeout, final BatchFetchListener listener) {
        this.checkState();
        ConsumerClient client = this.consumerClientManager.getOrCreateClient(brokerNode);
        this.handleAddConsumers(brokerNode, topics, app, client);
        try {
            client.asyncFetchTopicMessage(topics, app, count, timeout, ackTimeout, longPollTimeout, new CommandCallback(){

                public void onSuccess(Command request, Command response) {
                    FetchTopicMessageResponse fetchTopicMessageResponse = (FetchTopicMessageResponse)response.getPayload();
                    Map<String, FetchMessageData> consumeMessages = BrokerMessageConverter.convert(app, fetchTopicMessageResponse.getData());
                    listener.onMessage(consumeMessages);
                }

                public void onException(Command request, Throwable cause) {
                    listener.onException(cause);
                }
            });
        }
        catch (ClientException e) {
            listener.onException(e);
        }
    }

    @Override
    public Table<String, Short, FetchMessageData> batchFetchPartitions(BrokerNode brokerNode, Map<String, Short> partitions, String app, int count, long timeout) {
        this.checkState();
        ConsumerClient client = this.consumerClientManager.getOrCreateClient(brokerNode);
        this.handleAddConsumers(brokerNode, partitions.keySet(), app, client);
        FetchPartitionMessageResponse fetchPartitionMessageResponse = client.fetchPartitionMessage(partitions, app, count, timeout);
        return BrokerMessageConverter.convert(app, (Table<String, Short, FetchPartitionMessageAckData>)fetchPartitionMessageResponse.getData());
    }

    @Override
    public void batchFetchPartitionsAsync(BrokerNode brokerNode, Map<String, Short> partitions, final String app, int count, long timeout, final BatchPartitionFetchListener listener) {
        this.checkState();
        ConsumerClient client = this.consumerClientManager.getOrCreateClient(brokerNode);
        this.handleAddConsumers(brokerNode, partitions.keySet(), app, client);
        client.asyncFetchPartitionMessage(partitions, app, count, timeout, new CommandCallback(){

            public void onSuccess(Command request, Command response) {
                FetchPartitionMessageResponse fetchPartitionMessageResponse = (FetchPartitionMessageResponse)response.getPayload();
                Table<String, Short, FetchMessageData> fetchMessageDataTable = BrokerMessageConverter.convert(app, (Table<String, Short, FetchPartitionMessageAckData>)fetchPartitionMessageResponse.getData());
                listener.onMessage(fetchMessageDataTable);
            }

            public void onException(Command request, Throwable cause) {
                listener.onException(cause);
            }
        });
    }

    @Override
    public Table<String, Short, FetchMessageData> batchFetchPartitions(BrokerNode brokerNode, Table<String, Short, Long> partitions, String app, int count, long timeout) {
        this.checkState();
        ConsumerClient client = this.consumerClientManager.getOrCreateClient(brokerNode);
        this.handleAddConsumers(brokerNode, partitions.rowKeySet(), app, client);
        FetchPartitionMessageResponse fetchPartitionMessageResponse = client.fetchPartitionMessage(partitions, app, count, timeout);
        return BrokerMessageConverter.convert(app, (Table<String, Short, FetchPartitionMessageAckData>)fetchPartitionMessageResponse.getData());
    }

    @Override
    public void batchFetchPartitionsAsync(BrokerNode brokerNode, Table<String, Short, Long> partitions, final String app, int count, long timeout, final BatchPartitionFetchListener listener) {
        this.checkState();
        ConsumerClient client = this.consumerClientManager.getOrCreateClient(brokerNode);
        this.handleAddConsumers(brokerNode, partitions.rowKeySet(), app, client);
        client.asyncFetchPartitionMessage(partitions, app, count, timeout, new CommandCallback(){

            public void onSuccess(Command request, Command response) {
                FetchPartitionMessageResponse fetchPartitionMessageResponse = (FetchPartitionMessageResponse)response.getPayload();
                Table<String, Short, FetchMessageData> fetchMessageDataTable = BrokerMessageConverter.convert(app, (Table<String, Short, FetchPartitionMessageAckData>)fetchPartitionMessageResponse.getData());
                listener.onMessage(fetchMessageDataTable);
            }

            public void onException(Command request, Throwable cause) {
                listener.onException(cause);
            }
        });
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new ClientException("fetcher is not started", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }

    protected void handleAddConsumers(BrokerNode brokerNode, Collection<String> topics, String app, ConsumerClient client) {
        client.addConsumers(topics, app);
        this.connectionState.addBrokerNode(brokerNode);
        this.connectionState.addTopics(topics);
        this.connectionState.addApp(app);
    }

    protected void doStop() {
        this.handleRemoveConsumers();
    }

    protected void handleRemoveConsumers() {
        Set<BrokerNode> brokerNodes = this.connectionState.getBrokerNodes();
        Set<String> topics = this.connectionState.getTopics();
        Set<String> apps = this.connectionState.getApps();
        for (BrokerNode brokerNode : brokerNodes) {
            this.handleRemoveConsumers(brokerNode, topics, apps);
        }
    }

    protected void handleRemoveConsumers(BrokerNode brokerNode, Set<String> topics, Set<String> apps) {
        ConsumerClientGroup clientGroup = this.consumerClientManager.getClientGroup(brokerNode);
        if (clientGroup == null) {
            return;
        }
        for (String app : apps) {
            for (ConsumerClient client : clientGroup.getClients()) {
                try {
                    client.removeConsumers(topics, app);
                }
                catch (Exception e) {
                    logger.warn("remove consumers exception, topics: {}, app: {}, exception: {}", new Object[]{topics, app, e.getMessage()});
                    logger.debug("remove consumers exception, topics: {}, app: {}", new Object[]{topics, app, e});
                }
            }
        }
    }
}

