/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BrokerLoadBalance;
import org.joyqueue.client.internal.consumer.ConsumerIndexManager;
import org.joyqueue.client.internal.consumer.MessageFetcher;
import org.joyqueue.client.internal.consumer.MessagePoller;
import org.joyqueue.client.internal.consumer.callback.PollerListener;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.config.FetcherConfig;
import org.joyqueue.client.internal.consumer.coordinator.ConsumerCoordinator;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignment;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignments;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignmentsHolder;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.client.internal.consumer.exception.ConsumerException;
import org.joyqueue.client.internal.consumer.support.CompletableFuturePollerListener;
import org.joyqueue.client.internal.consumer.support.DefaultConsumerIndexManager;
import org.joyqueue.client.internal.consumer.support.DefaultMessageFetcher;
import org.joyqueue.client.internal.consumer.support.MessagePollerInner;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessagePoller
extends Service
implements MessagePoller {
    private static final int CUSTOM_BATCH_SIZE = -1;
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMessagePoller.class);
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ClusterClientManager clusterClientManager;
    private ConsumerClientManager consumerClientManager;
    private ConsumerCoordinator consumerCoordinator;
    private FetcherConfig fetcherConfig;
    private MessageFetcher messageFetcher;
    private ConsumerIndexManager consumerIndexManager;
    private MessagePollerInner messagePollerInner;
    private BrokerAssignmentsHolder brokerAssignmentCache;

    public DefaultMessagePoller(ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ClusterClientManager clusterClientManager, ConsumerClientManager consumerClientManager) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"consumer can not be null");
        Preconditions.checkArgument((nameServerConfig != null ? 1 : 0) != 0, (Object)"nameServer can not be null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager can not be null");
        Preconditions.checkArgument((clusterClientManager != null ? 1 : 0) != 0, (Object)"clusterClientManager can not be null");
        Preconditions.checkArgument((consumerClientManager != null ? 1 : 0) != 0, (Object)"consumerClientManager can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getApp()), (Object)"consumer.app not blank");
        Preconditions.checkArgument((config.getPollTimeout() > config.getLongPollTimeout() ? 1 : 0) != 0, (Object)"consumer.pollTimeout must be greater than consumer.longPullTimeout");
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.clusterClientManager = clusterClientManager;
        this.consumerClientManager = consumerClientManager;
    }

    protected void validate() throws Exception {
        this.consumerCoordinator = new ConsumerCoordinator(this.clusterClientManager);
        this.fetcherConfig = new FetcherConfig();
        this.messageFetcher = new DefaultMessageFetcher(this.consumerClientManager, this.fetcherConfig);
        this.consumerIndexManager = new DefaultConsumerIndexManager(this.clusterManager, this.consumerClientManager);
        this.messagePollerInner = new MessagePollerInner(this.config, this.nameServerConfig, this.clusterManager, this.consumerClientManager, this.messageFetcher);
    }

    protected void doStart() throws Exception {
        this.messageFetcher.start();
        this.consumerCoordinator.start();
        this.messagePollerInner.start();
    }

    protected void doStop() {
        if (this.messagePollerInner != null) {
            this.messagePollerInner.stop();
        }
        if (this.consumerCoordinator != null) {
            this.consumerCoordinator.stop();
        }
        if (this.messageFetcher != null) {
            this.messageFetcher.stop();
        }
    }

    @Override
    public ConsumeMessage pollOnce(String topic) {
        return this.pollOnce(topic, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ConsumeMessage pollOnce(String topic, long timeout, TimeUnit timeoutUnit) {
        List<ConsumeMessage> consumeMessages = this.doPoll(topic, 1, timeout, timeoutUnit, null);
        if (CollectionUtils.isEmpty(consumeMessages)) {
            return null;
        }
        return consumeMessages.get(0);
    }

    @Override
    public List<ConsumeMessage> poll(String topic) {
        return this.poll(topic, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<ConsumeMessage> poll(String topic, long timeout, TimeUnit timeoutUnit) {
        return this.doPoll(topic, -1, timeout, timeoutUnit, null);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(String topic) {
        return this.pollAsync(topic, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(String topic, long timeout, TimeUnit timeoutUnit) {
        CompletableFuture<List<ConsumeMessage>> future = new CompletableFuture<List<ConsumeMessage>>();
        this.doPoll(topic, -1, timeout, timeoutUnit, new CompletableFuturePollerListener(future));
        return future;
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition) {
        return this.pollPartitionOnce(topic, partition, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        List<ConsumeMessage> consumeMessages = this.doPollPartition(topic, partition, 1, timeout, timeoutUnit, null);
        if (CollectionUtils.isEmpty(consumeMessages)) {
            return null;
        }
        return consumeMessages.get(0);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long index) {
        return this.pollPartitionOnce(topic, partition, index, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        List<ConsumeMessage> consumeMessages = this.doPollPartition(topic, partition, index, 1, this.config.getPollTimeout(), TimeUnit.MILLISECONDS, null);
        if (CollectionUtils.isEmpty(consumeMessages)) {
            return null;
        }
        return consumeMessages.get(0);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition) {
        return this.pollPartition(topic, partition, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        return this.doPollPartition(topic, partition, -1, timeout, timeoutUnit, null);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long index) {
        return this.pollPartition(topic, partition, index, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.doPollPartition(topic, partition, index, -1, this.config.getPollTimeout(), TimeUnit.MILLISECONDS, null);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition) {
        return this.pollPartitionAsync(topic, partition, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        CompletableFuture<List<ConsumeMessage>> future = new CompletableFuture<List<ConsumeMessage>>();
        this.doPollPartition(topic, partition, -1, timeout, timeoutUnit, new CompletableFuturePollerListener(future));
        return future;
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long index) {
        return this.pollPartitionAsync(topic, partition, index, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        CompletableFuture<List<ConsumeMessage>> future = new CompletableFuture<List<ConsumeMessage>>();
        this.doPollPartition(topic, partition, index, -1, timeout, timeoutUnit, new CompletableFuturePollerListener(future));
        return future;
    }

    protected List<ConsumeMessage> doPollPartition(String topic, short partition, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        return this.doPollPartition(topic, partition, -1L, batchSize, timeout, timeoutUnit, listener);
    }

    protected List<ConsumeMessage> doPollPartition(String topic, short partition, long index, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        PartitionMetadata partitionMetadata = topicMetadata.getPartition(partition);
        if (partitionMetadata == null) {
            throw new ConsumerException(String.format("partition not exist, topic: %s, partition: %s", topic, partition), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (partitionMetadata.getLeader() == null) {
            throw new ConsumerException(String.format("partition not available, topic: %s, partition: %s", topic, partition), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (!partitionMetadata.getLeader().isReadable()) {
            throw new ConsumerException(String.format("partition not readable, topic: %s, partition: %s", topic, partition), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (batchSize == -1) {
            batchSize = this.config.getBatchSize() == -1 ? (int)topicMetadata.getConsumerPolicy().getBatchSize().shortValue() : this.config.getBatchSize();
        }
        return this.messagePollerInner.fetchPartition(partitionMetadata.getLeader(), topicMetadata, partition, index, batchSize, timeout, timeoutUnit, listener);
    }

    protected List<ConsumeMessage> doPoll(String topic, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        BrokerLoadBalance brokerBalance = this.messagePollerInner.getBrokerLoadBalance(topic);
        BrokerAssignments brokerAssignments = this.fetchBrokerAssignment(topicMetadata);
        brokerAssignments = this.messagePollerInner.filterNotAvailableBrokers(brokerAssignments);
        if (CollectionUtils.isEmpty(brokerAssignments.getAssignments())) {
            logger.warn("no broker available, topic: {}", (Object)topicMetadata.getTopic());
            return this.messagePollerInner.buildPollEmptyResult(listener);
        }
        if (batchSize == -1) {
            batchSize = this.config.getBatchSize() != -1 ? this.config.getBatchSize() : (int)topicMetadata.getConsumerPolicy().getBatchSize().shortValue();
        }
        BrokerAssignment brokerAssignment = brokerBalance.loadBalance(brokerAssignments);
        return this.messagePollerInner.fetchTopic(brokerAssignment.getBroker(), topicMetadata, batchSize, timeout, timeoutUnit, listener);
    }

    protected BrokerAssignments fetchBrokerAssignment(TopicMetadata topicMetadata) {
        if (this.brokerAssignmentCache != null && !this.brokerAssignmentCache.isExpired(this.config.getSessionTimeout())) {
            return this.brokerAssignmentCache.getBrokerAssignments();
        }
        BrokerAssignments brokerAssignments = null;
        if (this.config.isLoadBalance()) {
            brokerAssignments = this.consumerCoordinator.fetchBrokerAssignment(topicMetadata, this.config.getAppFullName(), this.config.getSessionTimeout());
            if (((brokerAssignments = this.messagePollerInner.filterNotAvailableBrokers(brokerAssignments)) == null || CollectionUtils.isEmpty(brokerAssignments.getAssignments())) && this.config.isFailover()) {
                logger.debug("no assignment available, assign all broker, topic: {}", (Object)topicMetadata.getTopic());
                brokerAssignments = this.messagePollerInner.buildAllBrokerAssignments(topicMetadata);
            }
        } else {
            brokerAssignments = this.messagePollerInner.buildAllBrokerAssignments(topicMetadata);
        }
        brokerAssignments = this.messagePollerInner.filterRegionBrokers(topicMetadata, brokerAssignments);
        if (topicMetadata.isAllAvailable()) {
            this.brokerAssignmentCache = new BrokerAssignmentsHolder(brokerAssignments, SystemClock.now());
        }
        return brokerAssignments;
    }

    @Override
    public synchronized JoyQueueCode reply(String topic, List<ConsumeReply> replyList) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        if (CollectionUtils.isEmpty(replyList)) {
            throw new IllegalArgumentException(String.format("topic %s reply is empty", topic));
        }
        JoyQueueCode result = this.consumerIndexManager.commitReply(topicMetadata.getTopic(), replyList, this.config.getAppFullName(), this.config.getTimeout());
        if (!result.equals((Object)JoyQueueCode.SUCCESS)) {
            logger.warn("commit ack error, topic : {}, code: {}, error: {}", new Object[]{topic, result.getCode(), result.getMessage(new Object[0])});
        }
        return result;
    }

    @Override
    public JoyQueueCode replyOnce(String topic, ConsumeReply reply) {
        return this.reply(topic, Lists.newArrayList((Object[])new ConsumeReply[]{reply}));
    }

    @Override
    public FetchIndexData fetchIndex(String topic, short partition) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        return this.consumerIndexManager.fetchIndex(topicMetadata.getTopic(), this.config.getAppFullName(), partition, this.config.getTimeout());
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        String topicFullName = this.messagePollerInner.getTopicFullName(topic);
        return this.clusterManager.fetchTopicMetadata(topicFullName, this.config.getAppFullName());
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new ConsumerException("consumer is not started", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }
}

