/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.client.internal.consumer.ConsumerIndexManager;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.client.internal.consumer.domain.LocalIndexData;
import org.joyqueue.client.internal.consumer.support.ConsumerLocalIndexStore;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConsumerIndexManager
extends Service
implements ConsumerIndexManager {
    protected static final Logger logger = LoggerFactory.getLogger(LocalConsumerIndexManager.class);
    private ConsumerConfig config;
    private ConsumerIndexManager delegate;
    private ConsumerLocalIndexStore consumerIndexStore;

    public LocalConsumerIndexManager(ConsumerConfig config, ConsumerIndexManager delegate) {
        this.config = config;
        this.delegate = delegate;
    }

    protected void validate() throws Exception {
        this.consumerIndexStore = new ConsumerLocalIndexStore(this.config.getBroadcastLocalPath() + File.separator + this.config.getBroadcastGroup(), this.config.getBroadcastPersistInterval());
    }

    protected void doStart() throws Exception {
        this.consumerIndexStore.start();
    }

    protected void doStop() {
        if (this.consumerIndexStore != null) {
            this.consumerIndexStore.stop();
        }
    }

    @Override
    public JoyQueueCode resetIndex(String topic, String app, short partition, long timeout) {
        FetchIndexData fetchIndexData = this.delegate.fetchIndex(topic, app, partition, timeout);
        if (!fetchIndexData.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
            logger.error("resetIndex error, topic: {}, partition: {}, error: {}", new Object[]{topic, partition, fetchIndexData.getCode()});
            return fetchIndexData.getCode();
        }
        if (fetchIndexData.getLeftIndex() >= 0L) {
            this.consumerIndexStore.saveIndex(topic, app, partition, fetchIndexData.getLeftIndex());
        } else {
            this.consumerIndexStore.saveIndex(topic, app, partition, fetchIndexData.getIndex());
        }
        return JoyQueueCode.SUCCESS;
    }

    @Override
    public FetchIndexData fetchIndex(String topic, String app, short partition, long timeout) {
        LocalIndexData localIndexData = this.consumerIndexStore.fetchIndex(topic, app, partition);
        FetchIndexData fetchIndexData = this.delegate.fetchIndex(topic, app, partition, timeout);
        if (localIndexData != null && !this.isExpired(localIndexData)) {
            return new FetchIndexData(localIndexData.getIndex(), fetchIndexData.getLeftIndex(), fetchIndexData.getRightIndex(), JoyQueueCode.SUCCESS);
        }
        if (!fetchIndexData.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
            logger.error("batchFetch index error, topic: {}, partition: {}, error: {}", new Object[]{topic, partition, fetchIndexData.getCode()});
        } else {
            this.consumerIndexStore.saveIndex(topic, app, partition, fetchIndexData.getIndex());
        }
        return fetchIndexData;
    }

    @Override
    public JoyQueueCode commitReply(String topic, List<ConsumeReply> replyList, String app, long timeout) {
        for (ConsumeReply reply : replyList) {
            this.consumerIndexStore.saveIndex(topic, app, reply.getPartition(), reply.getIndex() + 1L);
        }
        return JoyQueueCode.SUCCESS;
    }

    @Override
    public Table<String, Short, FetchIndexData> batchFetchIndex(Map<String, List<Short>> topicMap, String app, long timeout) {
        HashBasedTable result = HashBasedTable.create();
        Map updateTopicMap = null;
        for (Map.Entry<String, List<Short>> topicEntry : topicMap.entrySet()) {
            String topic = topicEntry.getKey();
            for (Short partition : topicEntry.getValue()) {
                FetchIndexData fetchIndexData = this.delegate.fetchIndex(topic, app, partition, timeout);
                LocalIndexData localIndexData = this.consumerIndexStore.fetchIndex(topic, app, partition);
                if (localIndexData == null || this.isExpired(localIndexData)) {
                    List partitions;
                    if (updateTopicMap == null) {
                        updateTopicMap = Maps.newHashMap();
                    }
                    if ((partitions = (List)updateTopicMap.get(topic)) == null) {
                        partitions = Lists.newLinkedList();
                        updateTopicMap.put(topic, partitions);
                    }
                    partitions.add(partition);
                    continue;
                }
                result.put((Object)topic, (Object)partition, (Object)new FetchIndexData(localIndexData.getIndex(), fetchIndexData.getLeftIndex(), fetchIndexData.getRightIndex(), JoyQueueCode.SUCCESS));
            }
        }
        if (MapUtils.isNotEmpty(updateTopicMap)) {
            Table<String, Short, FetchIndexData> fetchIndexTable = this.delegate.batchFetchIndex(updateTopicMap, app, timeout);
            for (Map.Entry topicEntry : updateTopicMap.entrySet()) {
                String topic = (String)topicEntry.getKey();
                for (Short partition : (List)topicEntry.getValue()) {
                    FetchIndexData fetchIndexData = (FetchIndexData)fetchIndexTable.get((Object)topic, (Object)partition);
                    if (!fetchIndexData.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                        logger.error("batchFetch index error, topic: {}, partition: {}, error: {}", new Object[]{topic, partition, fetchIndexData.getCode()});
                    } else {
                        this.consumerIndexStore.saveIndex(topic, app, partition, fetchIndexData.getIndex());
                    }
                    result.put((Object)topic, (Object)partition, (Object)fetchIndexData);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, JoyQueueCode> batchCommitReply(Map<String, List<ConsumeReply>> replyMap, String app, long timeout) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<ConsumeReply>> entry : replyMap.entrySet()) {
            String topic = entry.getKey();
            for (ConsumeReply consumeReply : entry.getValue()) {
                this.consumerIndexStore.saveIndex(topic, app, consumeReply.getPartition(), consumeReply.getIndex());
            }
        }
        return result;
    }

    protected boolean isExpired(LocalIndexData localIndexData) {
        if (this.config.getBroadcastIndexExpireTime() == -1) {
            return false;
        }
        return localIndexData.isExpired(this.config.getBroadcastIndexExpireTime());
    }
}

