/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BatchMessageListener;
import org.joyqueue.client.internal.consumer.MessageConsumer;
import org.joyqueue.client.internal.consumer.MessageListener;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptor;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;

public class MessageConsumerWrapper
extends Service
implements MessageConsumer {
    private ConsumerConfig consumerConfig;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ClusterClientManager clusterClientManager;
    private ConsumerClientManager consumerClientManager;
    private MessageConsumer delegate;

    public MessageConsumerWrapper(ConsumerConfig consumerConfig, NameServerConfig nameServerConfig, ClusterManager clusterManager, ClusterClientManager clusterClientManager, ConsumerClientManager consumerClientManager, MessageConsumer delegate) {
        this.consumerConfig = consumerConfig;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.clusterClientManager = clusterClientManager;
        this.consumerClientManager = consumerClientManager;
        this.delegate = delegate;
    }

    protected void doStart() throws Exception {
        if (this.clusterClientManager != null) {
            this.clusterClientManager.start();
        }
        if (this.clusterManager != null) {
            this.clusterManager.start();
        }
        if (this.consumerClientManager != null) {
            this.consumerClientManager.start();
        }
        this.delegate.start();
    }

    protected void doStop() {
        this.delegate.stop();
        if (this.consumerClientManager != null) {
            this.consumerClientManager.stop();
        }
        if (this.clusterManager != null) {
            this.clusterManager.stop();
        }
        if (this.clusterClientManager != null) {
            this.clusterClientManager.stop();
        }
    }

    @Override
    public void subscribe(String topic) {
        this.delegate.subscribe(topic);
    }

    @Override
    public void unsubscribe() {
        this.delegate.unsubscribe();
    }

    @Override
    public String subscription() {
        return this.delegate.subscription();
    }

    @Override
    public boolean isSubscribed() {
        return this.delegate.isSubscribed();
    }

    @Override
    public void subscribe(String topic, MessageListener messageListener) {
        this.delegate.subscribe(topic, messageListener);
    }

    @Override
    public void subscribeBatch(String topic, BatchMessageListener batchMessageListener) {
        this.delegate.subscribeBatch(topic, batchMessageListener);
    }

    @Override
    public void resumeListen() {
        this.delegate.resumeListen();
    }

    @Override
    public void suspendListen() {
        this.delegate.suspendListen();
    }

    @Override
    public boolean isListenSuspended() {
        return this.delegate.isListenSuspended();
    }

    @Override
    public void addInterceptor(ConsumerInterceptor interceptor) {
        this.delegate.addInterceptor(interceptor);
    }

    @Override
    public void removeInterceptor(ConsumerInterceptor interceptor) {
        this.delegate.removeInterceptor(interceptor);
    }

    @Override
    public ConsumeMessage pollOnce() {
        return this.delegate.pollOnce();
    }

    @Override
    public ConsumeMessage pollOnce(long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollOnce(timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> poll() {
        return this.delegate.poll();
    }

    @Override
    public List<ConsumeMessage> poll(long timeout, TimeUnit timeoutUnit) {
        return this.delegate.poll(timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync() {
        return this.delegate.pollAsync();
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollAsync(timeout, timeoutUnit);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition) {
        return this.delegate.pollPartitionOnce(partition);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionOnce(partition, timeout, timeoutUnit);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition, long index) {
        return this.delegate.pollPartitionOnce(partition, index);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionOnce(partition, index, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition) {
        return this.delegate.pollPartition(partition);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartition(partition, timeout, timeoutUnit);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition, long index) {
        return this.delegate.pollPartition(partition, index);
    }

    @Override
    public List<ConsumeMessage> pollPartition(short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartition(partition, index, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition) {
        return this.delegate.pollPartitionAsync(partition);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionAsync(partition, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition, long index) {
        return this.delegate.pollPartitionAsync(partition, index);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.pollPartitionAsync(partition, index, timeout, timeoutUnit);
    }

    @Override
    public JoyQueueCode reply(List<ConsumeReply> replyList) {
        return this.delegate.reply(replyList);
    }

    @Override
    public JoyQueueCode replyOnce(ConsumeReply reply) {
        return this.delegate.replyOnce(reply);
    }

    @Override
    public FetchIndexData fetchIndex(short partition) {
        return this.delegate.fetchIndex(partition);
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        return this.delegate.getTopicMetadata(topic);
    }
}

