/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import org.joyqueue.client.internal.consumer.MessageFetcher;
import org.joyqueue.client.internal.consumer.callback.BatchFetchListener;
import org.joyqueue.client.internal.consumer.callback.BatchPartitionFetchListener;
import org.joyqueue.client.internal.consumer.callback.FetchListener;
import org.joyqueue.client.internal.consumer.callback.PartitionFetchListener;
import org.joyqueue.client.internal.consumer.domain.FetchMessageData;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;

public class MessageFetcherWrapper
extends Service
implements MessageFetcher {
    private ConsumerClientManager consumerClientManager;
    private MessageFetcher delegate;

    public MessageFetcherWrapper(ConsumerClientManager consumerClientManager, MessageFetcher delegate) {
        this.consumerClientManager = consumerClientManager;
        this.delegate = delegate;
    }

    protected void doStart() throws Exception {
        this.consumerClientManager.start();
        this.delegate.start();
    }

    protected void doStop() {
        this.delegate.stop();
        this.consumerClientManager.stop();
    }

    @Override
    public FetchMessageData fetch(BrokerNode brokerNode, String topic, String app, int count, long timeout, long ackTimeout, long longPollTimeout) {
        return this.delegate.fetch(brokerNode, topic, app, count, timeout, ackTimeout, longPollTimeout);
    }

    @Override
    public void asyncFetch(BrokerNode brokerNode, String topic, String app, int count, long timeout, long ackTimeout, long longPollTimeout, FetchListener listener) {
        this.delegate.asyncFetch(brokerNode, topic, app, count, timeout, ackTimeout, longPollTimeout, listener);
    }

    @Override
    public FetchMessageData fetchPartition(BrokerNode brokerNode, String topic, String app, short partition, int count, long timeout) {
        return this.delegate.fetchPartition(brokerNode, topic, app, partition, count, timeout);
    }

    @Override
    public void fetchPartitionAsync(BrokerNode brokerNode, String topic, String app, short partition, int count, long timeout, PartitionFetchListener listener) {
        this.delegate.fetchPartitionAsync(brokerNode, topic, app, partition, count, count, listener);
    }

    @Override
    public FetchMessageData fetchPartition(BrokerNode brokerNode, String topic, String app, short partition, long index, int count, long timeout) {
        return this.delegate.fetchPartition(brokerNode, topic, app, partition, index, count, timeout);
    }

    @Override
    public void fetchPartitionAsync(BrokerNode brokerNode, String topic, String app, short partition, long index, int count, long timeout, PartitionFetchListener listener) {
        this.delegate.fetchPartitionAsync(brokerNode, topic, app, partition, index, count, timeout, listener);
    }

    @Override
    public Map<String, FetchMessageData> batchFetch(BrokerNode brokerNode, List<String> topics, String app, int count, long timeout, long ackTimeout, long longPollTimeout) {
        return this.delegate.batchFetch(brokerNode, topics, app, count, timeout, ackTimeout, longPollTimeout);
    }

    @Override
    public void batchFetchAsync(BrokerNode brokerNode, List<String> topics, String app, int count, long timeout, long ackTimeout, long longPollTimeout, BatchFetchListener listener) {
        this.delegate.batchFetchAsync(brokerNode, topics, app, count, timeout, ackTimeout, longPollTimeout, listener);
    }

    @Override
    public Table<String, Short, FetchMessageData> batchFetchPartitions(BrokerNode brokerNode, Map<String, Short> partitions, String app, int count, long timeout) {
        return this.delegate.batchFetchPartitions(brokerNode, partitions, app, count, timeout);
    }

    @Override
    public void batchFetchPartitionsAsync(BrokerNode brokerNode, Map<String, Short> partitions, String app, int count, long timeout, BatchPartitionFetchListener listener) {
        this.delegate.batchFetchPartitionsAsync(brokerNode, partitions, app, count, timeout, listener);
    }

    @Override
    public Table<String, Short, FetchMessageData> batchFetchPartitions(BrokerNode brokerNode, Table<String, Short, Long> partitions, String app, int count, long timeout) {
        return this.delegate.batchFetchPartitions(brokerNode, partitions, app, count, timeout);
    }

    @Override
    public void batchFetchPartitionsAsync(BrokerNode brokerNode, Table<String, Short, Long> partitions, String app, int count, long timeout, BatchPartitionFetchListener listener) {
        this.delegate.batchFetchPartitionsAsync(brokerNode, partitions, app, count, timeout, listener);
    }
}

