/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.collect.Lists;
import java.util.List;
import org.joyqueue.client.internal.consumer.BaseMessageListener;
import org.joyqueue.client.internal.consumer.BatchMessageListener;
import org.joyqueue.client.internal.consumer.MessageListener;

public class MessageListenerManager {
    private List<MessageListener> listeners = Lists.newLinkedList();
    private List<BatchMessageListener> batchListeners = Lists.newLinkedList();

    public void addListener(BaseMessageListener messageListener) {
        if (messageListener instanceof MessageListener) {
            this.listeners.add((MessageListener)messageListener);
        } else if (messageListener instanceof BatchMessageListener) {
            this.batchListeners.add((BatchMessageListener)messageListener);
        }
    }

    public void removeListener(BaseMessageListener messageListener) {
        this.listeners.remove(messageListener);
        this.batchListeners.remove(messageListener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty() && this.batchListeners.isEmpty();
    }

    public List<MessageListener> getListeners() {
        return this.listeners;
    }

    public List<BatchMessageListener> getBatchListeners() {
        return this.batchListeners;
    }
}

