/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BrokerLoadBalance;
import org.joyqueue.client.internal.consumer.MessageFetcher;
import org.joyqueue.client.internal.consumer.callback.FetchListener;
import org.joyqueue.client.internal.consumer.callback.PartitionFetchListener;
import org.joyqueue.client.internal.consumer.callback.PollerListener;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.converter.BrokerAssignmentConverter;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignment;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignments;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.FetchMessageData;
import org.joyqueue.client.internal.consumer.exception.ConsumerException;
import org.joyqueue.client.internal.consumer.support.BrokerLoadBalanceManager;
import org.joyqueue.client.internal.consumer.transport.ConsumerClient;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.client.internal.trace.TraceBuilder;
import org.joyqueue.client.internal.trace.TraceCaller;
import org.joyqueue.client.internal.trace.TraceType;
import org.joyqueue.client.internal.transport.ClientState;
import org.joyqueue.domain.ConsumerPolicy;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePollerInner
extends Service {
    public static final long FETCH_PARTITION_NONE_INDEX = -1L;
    protected static final Logger logger = LoggerFactory.getLogger(MessagePollerInner.class);
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ConsumerClientManager consumerClientManager;
    private MessageFetcher messageFetcher;
    private BrokerLoadBalanceManager brokerLoadBalanceManager;
    private String appFullName;

    public MessagePollerInner(ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ConsumerClientManager consumerClientManager, MessageFetcher messageFetcher) {
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.consumerClientManager = consumerClientManager;
        this.messageFetcher = messageFetcher;
    }

    protected void validate() throws Exception {
        this.brokerLoadBalanceManager = new BrokerLoadBalanceManager();
    }

    public List<ConsumeMessage> fetchTopic(BrokerNode brokerNode, String topic, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        TopicMetadata topicMetadata = this.getAndCheckTopicMetadata(topic);
        return this.fetchTopic(brokerNode, topicMetadata, batchSize, timeout, timeoutUnit, listener);
    }

    public List<ConsumeMessage> fetchTopic(BrokerNode brokerNode, TopicMetadata topicMetadata, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        TraceCaller caller = this.buildTraceCaller(topicMetadata);
        try {
            List<ConsumeMessage> consumeMessages = this.doFetchTopic(brokerNode, topicMetadata, batchSize, timeout, timeoutUnit, listener);
            caller.end();
            return consumeMessages;
        }
        catch (Exception e) {
            caller.error();
            if (e instanceof ConsumerException) {
                throw (ConsumerException)e;
            }
            throw new ConsumerException(e);
        }
    }

    protected List<ConsumeMessage> doFetchTopic(BrokerNode brokerNode, TopicMetadata topicMetadata, int batchSize, long timeout, TimeUnit timeoutUnit, final PollerListener listener) {
        long ackTimeout;
        ConsumerPolicy consumerPolicy = topicMetadata.getConsumerPolicy();
        timeout = timeoutUnit.toMillis(timeout);
        final String topic = topicMetadata.getTopic();
        final String app = this.config.getAppFullName();
        long l = ackTimeout = this.config.getAckTimeout() == -1L ? (long)consumerPolicy.getAckTimeout().intValue() : this.config.getAckTimeout();
        if (listener == null) {
            FetchMessageData fetchMessageData = this.messageFetcher.fetch(brokerNode, topic, app, batchSize, timeout, ackTimeout, this.config.getLongPollTimeout());
            return this.handleFetchMessageData(topic, app, fetchMessageData);
        }
        this.messageFetcher.asyncFetch(brokerNode, topic, app, batchSize, timeout, ackTimeout, this.config.getLongPollTimeout(), new FetchListener(){

            @Override
            public void onMessage(FetchMessageData fetchMessageData) {
                try {
                    List<ConsumeMessage> messages = MessagePollerInner.this.handleFetchMessageData(topic, app, fetchMessageData);
                    listener.onMessage(messages);
                }
                catch (Exception e) {
                    listener.onException(e);
                }
            }

            @Override
            public void onException(Throwable cause) {
                listener.onException(cause);
            }
        });
        return null;
    }

    public List<ConsumeMessage> fetchPartition(BrokerNode brokerNode, String topic, short partition, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        return this.fetchPartition(brokerNode, topic, partition, -1L, batchSize, timeout, timeoutUnit, listener);
    }

    public List<ConsumeMessage> fetchPartition(BrokerNode brokerNode, TopicMetadata topicMetadata, short partition, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        return this.fetchPartition(brokerNode, topicMetadata, partition, -1L, batchSize, timeout, timeoutUnit, listener);
    }

    public List<ConsumeMessage> fetchPartition(BrokerNode brokerNode, String topic, short partition, long index, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        TopicMetadata topicMetadata = this.getAndCheckTopicMetadata(topic);
        return this.fetchPartition(brokerNode, topicMetadata, partition, index, batchSize, timeout, timeoutUnit, listener);
    }

    public List<ConsumeMessage> fetchPartition(BrokerNode brokerNode, TopicMetadata topicMetadata, short partition, long index, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        Preconditions.checkArgument((topicMetadata != null ? 1 : 0) != 0, (Object)"topicMetadata not null");
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        TraceCaller caller = this.buildTraceCaller(topicMetadata);
        try {
            List<ConsumeMessage> consumeMessages = this.doFetchPartition(brokerNode, topicMetadata, partition, index, batchSize, timeout, timeoutUnit, listener);
            caller.end();
            return consumeMessages;
        }
        catch (Exception e) {
            caller.error();
            if (e instanceof ConsumerException) {
                throw (ConsumerException)e;
            }
            throw new ConsumerException(e);
        }
    }

    protected List<ConsumeMessage> doFetchPartition(BrokerNode brokerNode, TopicMetadata topicMetadata, short partition, long index, int batchSize, long timeout, TimeUnit timeoutUnit, final PollerListener listener) {
        timeout = timeoutUnit.toMillis(timeout);
        final String topic = topicMetadata.getTopic();
        final String app = this.config.getAppFullName();
        if (listener == null) {
            FetchMessageData fetchMessageData = index == -1L ? this.messageFetcher.fetchPartition(brokerNode, topic, app, partition, batchSize, timeout) : this.messageFetcher.fetchPartition(brokerNode, topic, app, partition, index, batchSize, timeout);
            return this.handleFetchMessageData(topic, app, fetchMessageData);
        }
        PartitionFetchListener partitionFetchListenerAdapter = new PartitionFetchListener(){

            @Override
            public void onMessage(FetchMessageData fetchMessageData) {
                try {
                    List<ConsumeMessage> consumeMessages = MessagePollerInner.this.handleFetchMessageData(topic, app, fetchMessageData);
                    listener.onMessage(consumeMessages);
                }
                catch (Exception e) {
                    listener.onException(e);
                }
            }

            @Override
            public void onException(Throwable cause) {
                listener.onException(cause);
            }
        };
        if (index == -1L) {
            this.messageFetcher.fetchPartitionAsync(brokerNode, topic, app, partition, index, batchSize, timeout, partitionFetchListenerAdapter);
        } else {
            this.messageFetcher.fetchPartitionAsync(brokerNode, topic, app, partition, batchSize, timeout, partitionFetchListenerAdapter);
        }
        return null;
    }

    protected List<ConsumeMessage> handleFetchMessageData(String topic, String app, FetchMessageData fetchMessageData) {
        if (fetchMessageData == null) {
            throw new ConsumerException(JoyQueueCode.CN_UNKNOWN_ERROR.getMessage(new Object[0]), JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
        }
        JoyQueueCode code = fetchMessageData.getCode();
        if (code.equals((Object)JoyQueueCode.SUCCESS)) {
            return fetchMessageData.getMessages();
        }
        switch (code) {
            case CN_NO_PERMISSION: 
            case CN_SERVICE_NOT_AVAILABLE: 
            case FW_FETCH_TOPIC_MESSAGE_BROKER_NOT_LEADER: {
                logger.warn("fetch message error, no permission, topic: {}", (Object)topic);
                this.clusterManager.updateTopicMetadata(topic, app);
                break;
            }
            case FW_GET_MESSAGE_TOPIC_NOT_READ: 
            case FW_FETCH_TOPIC_MESSAGE_PAUSED: {
                logger.debug("fetch message error, not read or paused, topic: {}", (Object)topic);
                break;
            }
            case FW_FETCH_MESSAGE_INDEX_OUT_OF_RANGE: 
            case SE_INDEX_OVERFLOW: 
            case SE_INDEX_UNDERFLOW: {
                logger.warn("fetch message index out of range, reset index, topic: {}, app: {}", (Object)topic, (Object)app);
                throw new ConsumerException(code.getMessage(new Object[0]), code.getCode());
            }
            case FW_TOPIC_NOT_EXIST: {
                logger.debug("fetch message error, topic not exist, topic: {}", (Object)topic);
                throw new ConsumerException(code.getMessage(new Object[0]), code.getCode());
            }
            case FW_BROKER_NOT_READABLE: {
                logger.debug("fetch message error, broker not readable, topic: {}", (Object)topic);
                this.clusterManager.updateTopicMetadata(topic, app);
                break;
            }
            default: {
                logger.error("fetch message error, topic: {}, code: {}, error: {}", new Object[]{topic, code, code.getMessage(new Object[0])});
            }
        }
        return Collections.emptyList();
    }

    protected TraceCaller buildTraceCaller(TopicMetadata topicMetadata) {
        return TraceBuilder.newInstance().topic(topicMetadata.getTopic()).app(this.config.getAppFullName()).namespace(this.nameServerConfig.getNamespace()).type(TraceType.CONSUMER_FETCH).begin();
    }

    public BrokerAssignments filterRegionBrokers(TopicMetadata topicMetadata, BrokerAssignments brokerAssignments) {
        if (!topicMetadata.getConsumerPolicy().getNearby().booleanValue() || CollectionUtils.isEmpty(brokerAssignments.getAssignments())) {
            return brokerAssignments;
        }
        List newAssignments = null;
        for (BrokerAssignment brokerAssignment : brokerAssignments.getAssignments()) {
            if (brokerAssignment.getBroker().isNearby()) continue;
            if (newAssignments == null) {
                newAssignments = Lists.newArrayList(brokerAssignments.getAssignments());
            }
            newAssignments.remove(brokerAssignment);
        }
        if (newAssignments == null) {
            return brokerAssignments;
        }
        return new BrokerAssignments(newAssignments);
    }

    public BrokerAssignments filterNotAvailableBrokers(BrokerAssignments brokerAssignments) {
        if (CollectionUtils.isEmpty(brokerAssignments.getAssignments())) {
            return brokerAssignments;
        }
        List newAssignments = null;
        for (BrokerAssignment brokerAssignment : brokerAssignments.getAssignments()) {
            ConsumerClient client = this.consumerClientManager.tryGetClient(brokerAssignment.getBroker());
            if (client == null || client.getState().equals((Object)ClientState.CONNECTED)) continue;
            if (newAssignments == null) {
                newAssignments = Lists.newArrayList(brokerAssignments.getAssignments());
            }
            newAssignments.remove(brokerAssignment);
        }
        if (newAssignments == null) {
            return brokerAssignments;
        }
        return new BrokerAssignments(newAssignments);
    }

    public BrokerLoadBalance getBrokerLoadBalance(String topic) {
        return this.brokerLoadBalanceManager.getBrokerLoadBalance(topic, this.config.getLoadBalanceType());
    }

    public List<ConsumeMessage> buildPollEmptyResult(PollerListener listener) {
        if (listener == null) {
            return Collections.emptyList();
        }
        listener.onMessage(Collections.emptyList());
        return null;
    }

    public BrokerAssignments buildAllBrokerAssignments(TopicMetadata topicMetadata) {
        return BrokerAssignmentConverter.convertBrokerAssignments(topicMetadata);
    }

    public TopicMetadata getAndCheckTopicMetadata(String topic) {
        TopicMetadata topicMetadata = this.clusterManager.fetchTopicMetadata(this.getTopicFullName(topic), this.config.getAppFullName());
        if (topicMetadata == null) {
            throw new ConsumerException(String.format("topic %s is not exist", topic), JoyQueueCode.FW_TOPIC_NOT_EXIST.getCode());
        }
        if (topicMetadata.getConsumerPolicy() == null) {
            throw new ConsumerException(String.format("topic %s consumer %s is not exist", topic, this.config.getAppFullName()), JoyQueueCode.FW_CONSUMER_NOT_EXISTS.getCode());
        }
        return topicMetadata;
    }

    public String getTopicFullName(String topic) {
        return NameServerHelper.getTopicFullName(topic, this.nameServerConfig);
    }
}

