/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.client.internal.consumer.MessageListener;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.converter.ConsumeMessageConverter;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.exception.IgnoreAckException;
import org.joyqueue.client.internal.consumer.interceptor.ConsumeContext;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInvoker;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.domain.ConsumerPolicy;
import org.joyqueue.network.command.RetryType;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnceConsumerInvoker
implements ConsumerInvoker {
    protected static final Logger logger = LoggerFactory.getLogger(OnceConsumerInvoker.class);
    private ConsumerConfig config;
    private TopicMetadata topicMetadata;
    private ConsumerPolicy consumerPolicy;
    private List<ConsumeMessage> messages;
    private List<MessageListener> listeners;

    public OnceConsumerInvoker(ConsumerConfig config, TopicMetadata topicMetadata, ConsumerPolicy consumerPolicy, List<ConsumeMessage> messages, List<MessageListener> listeners) {
        this.config = config;
        this.topicMetadata = topicMetadata;
        this.consumerPolicy = consumerPolicy;
        this.messages = messages;
        this.listeners = listeners;
    }

    @Override
    public List<ConsumeReply> invoke(ConsumeContext context) {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.messages.size());
        for (ConsumeMessage message : this.messages) {
            if (context.isFilteredMessage(message)) continue;
            long ackTimeout = this.config.getAckTimeout() != -1L ? this.config.getAckTimeout() : (long)this.consumerPolicy.getAckTimeout().intValue();
            RetryType retryType = RetryType.NONE;
            try {
                long startTime = SystemClock.now();
                for (MessageListener listener : this.listeners) {
                    listener.onMessage(message);
                }
                long endTime = SystemClock.now();
                if (endTime - startTime > ackTimeout) {
                    logger.warn("execute messageListener timeout, topic: {}, message: {}, listeners: {}", new Object[]{this.topicMetadata.getTopic(), message, this.listeners});
                    retryType = RetryType.NONE;
                }
            }
            catch (Exception e) {
                if (e instanceof IgnoreAckException) {
                    logger.debug("execute messageListener, ignore ack, topic: {}, message: {}, listeners: {}", new Object[]{this.topicMetadata.getTopic(), message, this.listeners});
                    retryType = RetryType.OTHER;
                }
                logger.error("execute messageListener exception, topic: {}, message: {}, listeners: {}", new Object[]{this.topicMetadata.getTopic(), message, this.listeners, e});
                retryType = RetryType.EXCEPTION;
            }
            result.add(new ConsumeReply(message.getPartition(), message.getIndex(), retryType));
        }
        return result;
    }

    @Override
    public List<ConsumeReply> reject(ConsumeContext context) {
        logger.info("reject execute listener, topic: {}, messages: {}", (Object)this.topicMetadata.getTopic(), this.messages);
        return ConsumeMessageConverter.convertToReply(this.messages, RetryType.NONE);
    }
}

