/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BrokerLoadBalance;
import org.joyqueue.client.internal.consumer.ConsumerIndexManager;
import org.joyqueue.client.internal.consumer.MessageFetcher;
import org.joyqueue.client.internal.consumer.MessagePoller;
import org.joyqueue.client.internal.consumer.callback.PollerListener;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.config.FetcherConfig;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignment;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignments;
import org.joyqueue.client.internal.consumer.coordinator.domain.PartitionAssignment;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.client.internal.consumer.exception.ConsumerException;
import org.joyqueue.client.internal.consumer.support.CompletableFuturePollerListener;
import org.joyqueue.client.internal.consumer.support.DefaultMessageFetcher;
import org.joyqueue.client.internal.consumer.support.MessagePollerInner;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionMessagePoller
extends Service
implements MessagePoller {
    private static final int CUSTOM_BATCH_SIZE = -1;
    protected static final Logger logger = LoggerFactory.getLogger(PartitionMessagePoller.class);
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ConsumerClientManager consumerClientManager;
    private FetcherConfig fetcherConfig;
    private MessageFetcher messageFetcher;
    private ConsumerIndexManager consumerIndexManager;
    private MessagePollerInner messagePollerInner;

    public PartitionMessagePoller(ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ConsumerClientManager consumerClientManager, ConsumerIndexManager consumerIndexManager) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"consumer not null");
        Preconditions.checkArgument((nameServerConfig != null ? 1 : 0) != 0, (Object)"nameServer not null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager not null");
        Preconditions.checkArgument((consumerIndexManager != null ? 1 : 0) != 0, (Object)"consumerIndexManager not null");
        Preconditions.checkArgument((consumerClientManager != null ? 1 : 0) != 0, (Object)"consumerClientManager not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getApp()), (Object)"consumer.app not blank");
        Preconditions.checkArgument((config.getPollTimeout() > config.getLongPollTimeout() ? 1 : 0) != 0, (Object)"consumer.pollTimeout must be greater than consumer.longPullTimeout");
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.consumerClientManager = consumerClientManager;
        this.consumerIndexManager = consumerIndexManager;
    }

    protected void validate() throws Exception {
        this.fetcherConfig = new FetcherConfig();
        this.messageFetcher = new DefaultMessageFetcher(this.consumerClientManager, this.fetcherConfig);
        this.messagePollerInner = new MessagePollerInner(this.config, this.nameServerConfig, this.clusterManager, this.consumerClientManager, this.messageFetcher);
    }

    protected void doStart() throws Exception {
        this.messageFetcher.start();
        this.messagePollerInner.start();
    }

    protected void doStop() {
        if (this.messagePollerInner != null) {
            this.messagePollerInner.stop();
        }
        if (this.messageFetcher != null) {
            this.messageFetcher.stop();
        }
    }

    @Override
    public ConsumeMessage pollOnce(String topic) {
        return this.pollOnce(topic, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ConsumeMessage pollOnce(String topic, long timeout, TimeUnit timeoutUnit) {
        List<ConsumeMessage> consumeMessages = this.doPoll(topic, 1, timeout, timeoutUnit, null);
        if (CollectionUtils.isEmpty(consumeMessages)) {
            return null;
        }
        return consumeMessages.get(0);
    }

    @Override
    public List<ConsumeMessage> poll(String topic) {
        return this.poll(topic, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<ConsumeMessage> poll(String topic, long timeout, TimeUnit timeoutUnit) {
        return this.doPoll(topic, -1, timeout, timeoutUnit, null);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(String topic) {
        return this.pollAsync(topic, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollAsync(String topic, long timeout, TimeUnit timeoutUnit) {
        return this.pollAsync(topic, timeout, timeoutUnit);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition) {
        return this.pollPartitionOnce(topic, partition, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        List<ConsumeMessage> consumeMessages = this.doPollPartition(topic, partition, 1, timeout, timeoutUnit, null);
        if (CollectionUtils.isEmpty(consumeMessages)) {
            return null;
        }
        return consumeMessages.get(0);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long index) {
        return this.pollPartitionOnce(topic, partition, index, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ConsumeMessage pollPartitionOnce(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        List<ConsumeMessage> consumeMessages = this.doPollPartition(topic, partition, index, 1, timeout, timeoutUnit, null);
        if (CollectionUtils.isEmpty(consumeMessages)) {
            return null;
        }
        return consumeMessages.get(0);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition) {
        return this.pollPartition(topic, partition, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        return this.doPollPartition(topic, partition, -1, timeout, timeoutUnit, null);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long index) {
        return this.pollPartition(topic, partition, index, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<ConsumeMessage> pollPartition(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        return this.doPollPartition(topic, partition, index, -1, timeout, timeoutUnit, null);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition) {
        return this.pollPartitionAsync(topic, partition, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long timeout, TimeUnit timeoutUnit) {
        CompletableFuture<List<ConsumeMessage>> future = new CompletableFuture<List<ConsumeMessage>>();
        this.doPollPartition(topic, partition, -1, timeout, timeoutUnit, new CompletableFuturePollerListener(future));
        return future;
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long index) {
        return this.pollPartitionAsync(topic, partition, index, this.config.getPollTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<List<ConsumeMessage>> pollPartitionAsync(String topic, short partition, long index, long timeout, TimeUnit timeoutUnit) {
        CompletableFuture<List<ConsumeMessage>> future = new CompletableFuture<List<ConsumeMessage>>();
        this.doPollPartition(topic, partition, index, -1, timeout, timeoutUnit, new CompletableFuturePollerListener(future));
        return future;
    }

    protected List<ConsumeMessage> doPollPartition(String topic, short partition, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        return this.doPollPartition(topic, partition, -1L, batchSize, timeout, timeoutUnit, listener);
    }

    protected List<ConsumeMessage> doPollPartition(String topic, short partition, long index, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        PartitionMetadata partitionMetadata = topicMetadata.getPartition(partition);
        if (partitionMetadata == null) {
            throw new ConsumerException(String.format("partition not exist, topic: %s, partition: %s", topic, partition), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (partitionMetadata.getLeader() == null) {
            throw new ConsumerException(String.format("partition not available, topic: %s, partition: %s", topic, partition), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (!partitionMetadata.getLeader().isReadable()) {
            throw new ConsumerException(String.format("partition not readable, topic: %s, partition: %s", topic, partition), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (batchSize == -1) {
            int n = batchSize = this.config.getBatchSize() == -1 ? (int)topicMetadata.getConsumerPolicy().getBatchSize().shortValue() : this.config.getBatchSize();
        }
        if (index == -1L) {
            return this.doPollPartitionInternal(partitionMetadata.getLeader(), topic, partition, batchSize, timeout, timeoutUnit, listener);
        }
        return this.doPollPartitionInternal(partitionMetadata.getLeader(), topic, partition, index, batchSize, timeout, timeoutUnit, listener);
    }

    protected List<ConsumeMessage> doPoll(String topic, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        BrokerAssignments brokerAssignments = this.buildAllBrokerAssignments(topicMetadata);
        brokerAssignments = this.messagePollerInner.filterRegionBrokers(topicMetadata, brokerAssignments);
        brokerAssignments = this.messagePollerInner.filterNotAvailableBrokers(brokerAssignments);
        if (CollectionUtils.isEmpty(brokerAssignments.getAssignments())) {
            logger.warn("no broker available, topic: {}", (Object)topicMetadata.getTopic());
            return this.messagePollerInner.buildPollEmptyResult(listener);
        }
        BrokerLoadBalance brokerBalance = this.messagePollerInner.getBrokerLoadBalance(topicMetadata.getTopic());
        BrokerAssignment brokerAssignment = brokerBalance.loadBalance(brokerAssignments);
        short partition = brokerAssignment.getPartitionAssignment().getPartitions().get(0);
        if (batchSize == -1) {
            batchSize = this.config.getBatchSize() != -1 ? this.config.getBatchSize() : (int)topicMetadata.getConsumerPolicy().getBatchSize().shortValue();
        }
        return this.doPollPartitionInternal(brokerAssignment.getBroker(), topic, partition, batchSize, timeout, timeoutUnit, listener);
    }

    protected List<ConsumeMessage> doPollPartitionInternal(BrokerNode brokerNode, String topic, short partition, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        FetchIndexData indexData = this.consumerIndexManager.fetchIndex(topic, this.config.getAppFullName(), partition, this.config.getTimeout());
        if (!indexData.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
            logger.error("fetch index error, topic: {}, partition: {}, app: {}, error:{}", new Object[]{topic, partition, this.config.getAppFullName(), indexData.getCode().getMessage(new Object[0])});
            return this.messagePollerInner.buildPollEmptyResult(listener);
        }
        return this.doPollPartitionInternal(brokerNode, topic, partition, indexData.getIndex(), batchSize, timeout, timeoutUnit, listener);
    }

    protected List<ConsumeMessage> doPollPartitionInternal(BrokerNode brokerNode, String topic, short partition, long index, int batchSize, long timeout, TimeUnit timeoutUnit, PollerListener listener) {
        try {
            return this.messagePollerInner.fetchPartition(brokerNode, topic, partition, index, batchSize, timeout, timeoutUnit, listener);
        }
        catch (ConsumerException e) {
            if (e.getCode() == JoyQueueCode.FW_FETCH_MESSAGE_INDEX_OUT_OF_RANGE.getCode()) {
                this.consumerIndexManager.resetIndex(topic, this.config.getApp(), partition, this.config.getTimeout());
                return this.messagePollerInner.buildPollEmptyResult(listener);
            }
            throw e;
        }
    }

    protected BrokerAssignments buildAllBrokerAssignments(TopicMetadata topicMetadata) {
        LinkedList assignments = Lists.newLinkedList();
        for (PartitionMetadata partitionMetadata : topicMetadata.getPartitions()) {
            if (partitionMetadata.getLeader() == null || !partitionMetadata.getLeader().isReadable()) continue;
            assignments.add(new BrokerAssignment(partitionMetadata.getLeader(), new PartitionAssignment(Lists.newArrayList((Object[])new Short[]{partitionMetadata.getId()}))));
        }
        return new BrokerAssignments(assignments);
    }

    @Override
    public synchronized JoyQueueCode reply(String topic, List<ConsumeReply> replyList) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        if (CollectionUtils.isEmpty(replyList)) {
            throw new IllegalArgumentException(String.format("topic %s reply is empty", topic));
        }
        JoyQueueCode result = this.consumerIndexManager.commitReply(topicMetadata.getTopic(), replyList, this.config.getAppFullName(), this.config.getTimeout());
        if (!result.equals((Object)JoyQueueCode.SUCCESS)) {
            logger.warn("commit ack error, topic : {}, code: {}, error: {}", new Object[]{topic, result.getCode(), result.getMessage(new Object[0])});
        }
        return result;
    }

    @Override
    public JoyQueueCode replyOnce(String topic, ConsumeReply reply) {
        return this.reply(topic, Lists.newArrayList((Object[])new ConsumeReply[]{reply}));
    }

    @Override
    public FetchIndexData fetchIndex(String topic, short partition) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        TopicMetadata topicMetadata = this.messagePollerInner.getAndCheckTopicMetadata(topic);
        return this.consumerIndexManager.fetchIndex(topicMetadata.getTopic(), this.config.getAppFullName(), partition, this.config.getTimeout());
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        String topicFullName = this.messagePollerInner.getTopicFullName(topic);
        return this.clusterManager.fetchTopicMetadata(topicFullName, this.config.getAppFullName());
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new ConsumerException("consumer is not started", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }
}

