/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import com.jd.laf.extension.Extension;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.joyqueue.client.internal.consumer.BrokerLoadBalance;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignment;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignments;

@Extension(singleton=false)
public class RoundRobinBrokerLoadBalance
implements BrokerLoadBalance {
    public static final String NAME = "roundrobin";
    private AtomicInteger next = new AtomicInteger();

    @Override
    public BrokerAssignment loadBalance(BrokerAssignments brokerAssignments) {
        List<BrokerAssignment> assignments = brokerAssignments.getAssignments();
        int index = this.next.getAndIncrement();
        if (index >= assignments.size()) {
            this.next.set(1);
            index = 0;
        }
        return assignments.get(index);
    }

    public String type() {
        return NAME;
    }
}

