/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BaseMessageListener;
import org.joyqueue.client.internal.consumer.MessagePoller;
import org.joyqueue.client.internal.consumer.MessagePollerFactory;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.coordinator.ConsumerCoordinator;
import org.joyqueue.client.internal.consumer.exception.ConsumerException;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptor;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptorManager;
import org.joyqueue.client.internal.consumer.support.MessageListenerManager;
import org.joyqueue.client.internal.consumer.support.TopicMessageConsumerDispatcher;
import org.joyqueue.client.internal.consumer.support.TopicMessageConsumerScheduler;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.metadata.domain.PartitionGroupMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.domain.TopicName;
import org.joyqueue.domain.TopicType;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicMessageConsumer
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ConsumerCoordinator.class);
    private String topic;
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ClusterClientManager clusterClientManager;
    private ConsumerClientManager consumerClientManager;
    private ConsumerInterceptorManager consumerInterceptorManager;
    private MessagePoller messagePoller;
    private TopicMessageConsumerDispatcher messageConsumerDispatcher;
    private TopicMessageConsumerScheduler messageConsumerScheduler;
    private MessageListenerManager messageListenerManager = new MessageListenerManager();
    private String appFullName;

    public TopicMessageConsumer(String topic, ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ClusterClientManager clusterClientManager, ConsumerClientManager consumerClientManager) {
        this(topic, config, nameServerConfig, clusterManager, clusterClientManager, consumerClientManager, new ConsumerInterceptorManager());
    }

    public TopicMessageConsumer(String topic, ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ClusterClientManager clusterClientManager, ConsumerClientManager consumerClientManager, ConsumerInterceptorManager consumerInterceptorManager) {
        this.topic = topic;
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.clusterClientManager = clusterClientManager;
        this.consumerClientManager = consumerClientManager;
        this.consumerInterceptorManager = consumerInterceptorManager;
    }

    protected void validate() throws Exception {
        this.messagePoller = this.createMessagePoller(this.topic);
        this.messageConsumerDispatcher = new TopicMessageConsumerDispatcher(this.topic, this.config, this.nameServerConfig, this.messagePoller, this.messageListenerManager, this.consumerInterceptorManager);
        this.messageConsumerScheduler = new TopicMessageConsumerScheduler(this.topic, this.config, this.messagePoller, this.messageConsumerDispatcher);
    }

    protected void doStart() throws Exception {
        this.messagePoller.start();
        if (!this.messageListenerManager.isEmpty()) {
            this.messageConsumerDispatcher.start();
            this.messageConsumerScheduler.start();
        }
    }

    protected void doStop() {
        if (!this.messageListenerManager.isEmpty()) {
            if (this.messageConsumerScheduler != null) {
                this.messageConsumerScheduler.stop();
            }
            if (this.messageConsumerDispatcher != null) {
                this.messageConsumerDispatcher.stop();
            }
        }
        if (this.messagePoller != null) {
            this.messagePoller.stop();
        }
    }

    public void suspend() {
        this.messageConsumerScheduler.suspend();
    }

    public boolean isSuspend() {
        return this.messageConsumerScheduler.isSuspend();
    }

    public void resume() {
        this.messageConsumerScheduler.resume();
    }

    protected MessagePoller createMessagePoller(String topic) {
        TopicName topicName = TopicName.parse((String)NameServerHelper.getTopicFullName(topic, this.nameServerConfig));
        TopicMetadata topicMetadata = this.clusterManager.fetchTopicMetadata(topicName.getFullName(), this.config.getAppFullName());
        if (topicMetadata == null) {
            throw new ConsumerException(String.format("topic %s is not exist", topic), JoyQueueCode.FW_TOPIC_NOT_EXIST.getCode());
        }
        if (topicMetadata.getConsumerPolicy() == null) {
            throw new ConsumerException(String.format("topic %s consumer %s is not exist", topic, this.config.getAppFullName()), JoyQueueCode.FW_TOPIC_NOT_EXIST.getCode());
        }
        if (this.config.getThread() == -1) {
            int maxPartition = 1;
            if (CollectionUtils.isNotEmpty(topicMetadata.getPartitionGroups())) {
                for (PartitionGroupMetadata partitionGroup : topicMetadata.getPartitionGroups()) {
                    maxPartition = Math.max(partitionGroup.getPartitions().size(), maxPartition);
                }
            }
            this.config.setThread(maxPartition);
        }
        if (topicMetadata.getType().equals((Object)TopicType.BROADCAST)) {
            return MessagePollerFactory.createBroadcastPoller(this.config, this.nameServerConfig, this.clusterManager, this.consumerClientManager);
        }
        return MessagePollerFactory.create(this.config, this.nameServerConfig, this.clusterManager, this.clusterClientManager, this.consumerClientManager);
    }

    public synchronized void addInterceptor(ConsumerInterceptor consumerInterceptor) {
        this.consumerInterceptorManager.addInterceptor(consumerInterceptor);
    }

    public synchronized void removeInterceptor(ConsumerInterceptor consumerInterceptor) {
        this.consumerInterceptorManager.removeInterceptor(consumerInterceptor);
    }

    public synchronized void addListener(BaseMessageListener messageListener) {
        boolean isEmpty = this.messageListenerManager.isEmpty();
        this.messageListenerManager.addListener(messageListener);
        if (this.isStarted() && isEmpty) {
            try {
                this.messageConsumerDispatcher.start();
                this.messageConsumerScheduler.start();
            }
            catch (Exception e) {
                throw new ConsumerException(e);
            }
        }
    }

    public synchronized void removeListener(BaseMessageListener messageListener) {
        this.messageListenerManager.removeListener(messageListener);
    }

    public MessagePoller getMessagePoller() {
        return this.messagePoller;
    }
}

