/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.consumer.BatchMessageListener;
import org.joyqueue.client.internal.consumer.MessageListener;
import org.joyqueue.client.internal.consumer.MessagePoller;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptorManager;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInvocation;
import org.joyqueue.client.internal.consumer.support.BatchConsumerInvoker;
import org.joyqueue.client.internal.consumer.support.MessageListenerManager;
import org.joyqueue.client.internal.consumer.support.OnceConsumerInvoker;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.domain.ConsumerPolicy;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicMessageConsumerDispatcher
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TopicMessageConsumerDispatcher.class);
    private String topic;
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private MessagePoller messagePoller;
    private MessageListenerManager messageListenerManager;
    private ConsumerInterceptorManager consumerInterceptorManager;

    public TopicMessageConsumerDispatcher(String topic, ConsumerConfig config, NameServerConfig nameServerConfig, MessagePoller messagePoller, MessageListenerManager messageListenerManager, ConsumerInterceptorManager consumerInterceptorManager) {
        this.topic = topic;
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.messagePoller = messagePoller;
        this.messageListenerManager = messageListenerManager;
        this.consumerInterceptorManager = consumerInterceptorManager;
    }

    public boolean dispatch() {
        if (this.messageListenerManager.isEmpty()) {
            return false;
        }
        List<ConsumeMessage> messages = this.messagePoller.poll(this.topic);
        if (logger.isDebugEnabled()) {
            logger.debug("poll messages, topic: {}, app: {}, messages: {}", new Object[]{this.topic, this.nameServerConfig.getApp(), messages});
        }
        if (CollectionUtils.isEmpty(messages)) {
            return false;
        }
        TopicMetadata topicMetadata = this.messagePoller.getTopicMetadata(this.topic);
        ConsumerPolicy consumerPolicy = topicMetadata.getConsumerPolicy();
        List<ConsumeReply> consumeReplies = this.doDispatch(topicMetadata, consumerPolicy, messages);
        if (logger.isDebugEnabled()) {
            logger.debug("reply messages, topic: {}, app: {}, replies: {}", new Object[]{this.topic, this.nameServerConfig.getApp(), consumeReplies});
        }
        this.messagePoller.reply(this.topic, consumeReplies);
        return true;
    }

    protected List<ConsumeReply> doDispatch(TopicMetadata topicMetadata, ConsumerPolicy consumerPolicy, List<ConsumeMessage> messages) {
        List<MessageListener> listeners = this.messageListenerManager.getListeners();
        List<BatchMessageListener> batchListeners = this.messageListenerManager.getBatchListeners();
        if (CollectionUtils.isNotEmpty(batchListeners)) {
            return this.doBatchDispatch(topicMetadata, consumerPolicy, messages, batchListeners);
        }
        return this.doOnceDispatch(topicMetadata, consumerPolicy, messages, listeners);
    }

    protected List<ConsumeReply> doBatchDispatch(TopicMetadata topicMetadata, ConsumerPolicy consumerPolicy, List<ConsumeMessage> messages, List<BatchMessageListener> listeners) {
        return new ConsumerInvocation(this.config, this.topic, this.nameServerConfig, messages, this.consumerInterceptorManager, new BatchConsumerInvoker(this.config, topicMetadata, consumerPolicy, messages, listeners)).invoke();
    }

    protected List<ConsumeReply> doOnceDispatch(TopicMetadata topicMetadata, ConsumerPolicy consumerPolicy, List<ConsumeMessage> messages, List<MessageListener> listeners) {
        return new ConsumerInvocation(this.config, this.topic, this.nameServerConfig, messages, this.consumerInterceptorManager, new OnceConsumerInvoker(this.config, topicMetadata, consumerPolicy, messages, listeners)).invoke();
    }
}

