/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.support;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.joyqueue.client.internal.consumer.MessagePoller;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.support.TopicMessageConsumerDispatcher;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicMessageConsumerScheduler
extends Service
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(TopicMessageConsumerScheduler.class);
    private String topic;
    private ConsumerConfig config;
    private MessagePoller messagePoller;
    private TopicMessageConsumerDispatcher messageConsumerDispatcher;
    private ExecutorService scheduleThreadPool;
    private volatile boolean suspend = false;
    private volatile boolean stopped = false;

    public TopicMessageConsumerScheduler(String topic, ConsumerConfig config, MessagePoller messagePoller, TopicMessageConsumerDispatcher messageConsumerDispatcher) {
        this.topic = topic;
        this.config = config;
        this.messagePoller = messagePoller;
        this.messageConsumerDispatcher = messageConsumerDispatcher;
    }

    protected void validate() throws Exception {
        this.scheduleThreadPool = Executors.newFixedThreadPool(this.config.getThread(), (ThreadFactory)new NamedThreadFactory(String.format("joyqueue-consumer-scheduler-%s", this.topic), true));
    }

    protected void doStart() throws Exception {
        for (int i = 0; i < this.config.getThread(); ++i) {
            this.scheduleThreadPool.execute(this);
        }
    }

    protected void doStop() {
        this.stopped = true;
        if (this.scheduleThreadPool != null) {
            this.scheduleThreadPool.shutdown();
        }
    }

    public void suspend() {
        this.suspend = true;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public void resume() {
        this.suspend = false;
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                if (this.suspend) {
                    Thread.currentThread();
                    Thread.sleep(this.config.getIdleInterval());
                    continue;
                }
                this.doSchedule();
            }
            catch (Exception e) {
                if (this.stopped) continue;
                logger.error("dispatch consumer exception, topic: {}", (Object)this.topic, (Object)e);
                try {
                    Thread.currentThread();
                    Thread.sleep(this.config.getIdleInterval());
                }
                catch (InterruptedException e1) {
                    logger.debug("dispatch consumer exception, topic: {}", (Object)this.topic, (Object)e1);
                }
            }
        }
    }

    protected void doSchedule() throws Exception {
        boolean result = this.messageConsumerDispatcher.dispatch();
        if (result) {
            if (this.config.getInterval() > 0L) {
                Thread.currentThread();
                Thread.sleep(this.config.getInterval());
            }
        } else {
            Thread.currentThread();
            Thread.sleep(this.config.getIdleInterval());
        }
    }
}

