/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.transport;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientConnectionListener;
import org.joyqueue.client.internal.consumer.transport.ConsumerConnectionState;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientState;
import org.joyqueue.network.command.CommitAckData;
import org.joyqueue.network.command.CommitAckRequest;
import org.joyqueue.network.command.CommitAckResponse;
import org.joyqueue.network.command.FetchIndexRequest;
import org.joyqueue.network.command.FetchIndexResponse;
import org.joyqueue.network.command.FetchPartitionMessageData;
import org.joyqueue.network.command.FetchPartitionMessageRequest;
import org.joyqueue.network.command.FetchPartitionMessageResponse;
import org.joyqueue.network.command.FetchTopicMessageData;
import org.joyqueue.network.command.FetchTopicMessageRequest;
import org.joyqueue.network.command.FetchTopicMessageResponse;
import org.joyqueue.network.transport.TransportAttribute;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerClient {
    private static final String CLIENT_CONSUMER_CACHE_KEY = "_CLIENT_CONSUMER_CACHE_";
    protected static final Logger logger = LoggerFactory.getLogger(ConsumerClient.class);
    private Client client;
    private ConsumerConnectionState connectionState;

    public static ConsumerClient build(Client client) {
        ConsumerClient consumerClient = (ConsumerClient)client.getAttribute().get((Object)CLIENT_CONSUMER_CACHE_KEY);
        if (consumerClient == null) {
            consumerClient = new ConsumerClient(client);
            ConsumerClient oldConsumerClient = (ConsumerClient)client.getAttribute().putIfAbsent((Object)CLIENT_CONSUMER_CACHE_KEY, (Object)consumerClient);
            if (oldConsumerClient != null) {
                consumerClient = oldConsumerClient;
            } else {
                consumerClient.getClient().addListener(new ConsumerClientConnectionListener(consumerClient.getClient().getTransport(), consumerClient));
            }
        }
        return consumerClient;
    }

    public ConsumerClient(Client client) {
        this.client = client;
        this.connectionState = new ConsumerConnectionState(this);
    }

    public FetchIndexResponse fetchIndex(Map<String, List<Short>> partitions, String app, long timeout) {
        FetchIndexRequest fetchIndexRequest = new FetchIndexRequest();
        fetchIndexRequest.setPartitions(partitions);
        fetchIndexRequest.setApp(app);
        return (FetchIndexResponse)this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)fetchIndexRequest), timeout).getPayload();
    }

    public CommitAckResponse commitAck(Table<String, Short, List<CommitAckData>> data, String app, long timeout) {
        CommitAckRequest commitAckRequest = new CommitAckRequest();
        commitAckRequest.setData(data);
        commitAckRequest.setApp(app);
        return (CommitAckResponse)this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)commitAckRequest), timeout).getPayload();
    }

    public void asyncFetchTopicMessage(List<String> topics, String app, int count, long timeout, long ackTimeout, long longPollTimeout, CommandCallback callback) {
        FetchTopicMessageRequest fetchTopicMessageRequest = this.buildFetchTopicMessageCommand(topics, app, count, ackTimeout, longPollTimeout);
        this.client.async((Command)new JoyQueueCommand((JoyQueuePayload)fetchTopicMessageRequest), timeout, callback);
    }

    public FetchTopicMessageResponse fetchTopicMessage(List<String> topics, String app, int count, long timeout, long ackTimeout, long longPollTimeout) {
        FetchTopicMessageRequest fetchTopicMessageRequest = this.buildFetchTopicMessageCommand(topics, app, count, ackTimeout, longPollTimeout);
        Command response = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)fetchTopicMessageRequest), timeout);
        return (FetchTopicMessageResponse)response.getPayload();
    }

    public FetchPartitionMessageResponse fetchPartitionMessage(Map<String, Short> partitions, String app, int count, long timeout) {
        FetchPartitionMessageRequest fetchPartitionMessageRequest = this.buildPartitionTopicMessageCommand(partitions, app, count);
        Command response = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)fetchPartitionMessageRequest), timeout);
        return (FetchPartitionMessageResponse)response.getPayload();
    }

    public void asyncFetchPartitionMessage(Map<String, Short> partitions, String app, int count, long timeout, CommandCallback callback) {
        FetchPartitionMessageRequest fetchPartitionMessageRequest = this.buildPartitionTopicMessageCommand(partitions, app, count);
        this.client.async((Command)new JoyQueueCommand((JoyQueuePayload)fetchPartitionMessageRequest), timeout, callback);
    }

    public FetchPartitionMessageResponse fetchPartitionMessage(Table<String, Short, Long> partitions, String app, int count, long timeout) {
        FetchPartitionMessageRequest fetchPartitionMessageRequest = this.buildPartitionTopicMessageCommand(partitions, app, count);
        Command response = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)fetchPartitionMessageRequest), timeout);
        return (FetchPartitionMessageResponse)response.getPayload();
    }

    public void asyncFetchPartitionMessage(Table<String, Short, Long> partitions, String app, int count, long timeout, CommandCallback callback) {
        FetchPartitionMessageRequest fetchPartitionMessageRequest = this.buildPartitionTopicMessageCommand(partitions, app, count);
        this.client.async((Command)new JoyQueueCommand((JoyQueuePayload)fetchPartitionMessageRequest), timeout, callback);
    }

    public void addConsumers() {
        this.connectionState.handleAddConsumers();
    }

    public void addConsumers(Collection<String> topics, String app) {
        this.connectionState.handleAddConsumers(topics, app);
    }

    public void removeConsumers(Collection<String> topics, String app) {
        this.connectionState.handleRemoveConsumers(topics, app);
    }

    public void close() {
        this.connectionState.handleRemoveConsumers();
        this.client.stop();
    }

    protected FetchPartitionMessageRequest buildPartitionTopicMessageCommand(Map<String, Short> partitions, String app, int count) {
        HashBasedTable partitionMap = HashBasedTable.create();
        for (Map.Entry<String, Short> entry : partitions.entrySet()) {
            partitionMap.put((Object)entry.getKey(), (Object)entry.getValue(), (Object)new FetchPartitionMessageData(count, -1L));
        }
        FetchPartitionMessageRequest fetchPartitionMessageRequest = new FetchPartitionMessageRequest();
        fetchPartitionMessageRequest.setPartitions((Table)partitionMap);
        fetchPartitionMessageRequest.setApp(app);
        return fetchPartitionMessageRequest;
    }

    protected FetchPartitionMessageRequest buildPartitionTopicMessageCommand(Table<String, Short, Long> partitions, String app, int count) {
        HashBasedTable partitionMap = HashBasedTable.create();
        for (Map.Entry topicEntry : partitions.rowMap().entrySet()) {
            String topic = (String)topicEntry.getKey();
            for (Map.Entry partitionEntry : ((Map)topicEntry.getValue()).entrySet()) {
                partitionMap.put((Object)topic, partitionEntry.getKey(), (Object)new FetchPartitionMessageData(count, ((Long)partitionEntry.getValue()).longValue()));
            }
        }
        FetchPartitionMessageRequest fetchPartitionMessageRequest = new FetchPartitionMessageRequest();
        fetchPartitionMessageRequest.setPartitions((Table)partitionMap);
        fetchPartitionMessageRequest.setApp(app);
        return fetchPartitionMessageRequest;
    }

    protected FetchTopicMessageRequest buildFetchTopicMessageCommand(List<String> topics, String app, int count, long ackTimeout, long longPollTimeout) {
        HashMap topicMap = Maps.newHashMap();
        for (String topic : topics) {
            topicMap.put(topic, new FetchTopicMessageData(count));
        }
        FetchTopicMessageRequest fetchTopicMessageRequest = new FetchTopicMessageRequest();
        fetchTopicMessageRequest.setTopics((Map)topicMap);
        fetchTopicMessageRequest.setApp(app);
        fetchTopicMessageRequest.setAckTimeout((int)ackTimeout);
        fetchTopicMessageRequest.setLongPollTimeout((int)longPollTimeout);
        return fetchTopicMessageRequest;
    }

    public TransportAttribute getAttribute() {
        return this.client.getAttribute();
    }

    public Client getClient() {
        return this.client;
    }

    public ClientState getState() {
        return this.client.getState();
    }
}

