/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.transport;

import org.joyqueue.client.internal.consumer.transport.ConsumerClient;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientGroup;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientGroup;
import org.joyqueue.client.internal.transport.ClientManager;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerClientManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ConsumerClientManager.class);
    private TransportConfig transportConfig;
    private NameServerConfig nameServerConfig;
    private ClientManager clientManager;

    public ConsumerClientManager(TransportConfig transportConfig, NameServerConfig nameServerConfig) {
        this.transportConfig = transportConfig;
        this.nameServerConfig = nameServerConfig;
    }

    public ConsumerClientGroup getClientGroup(BrokerNode node) {
        ClientGroup clientGroup = this.clientManager.getClientGroup(node);
        if (clientGroup == null) {
            return null;
        }
        return new ConsumerClientGroup(clientGroup);
    }

    public ConsumerClient createClient(BrokerNode node) {
        Client client = this.clientManager.createClient(node);
        return new ConsumerClient(client);
    }

    public ConsumerClient getOrCreateClient(BrokerNode node) {
        Client client = this.clientManager.getOrCreateClient(node);
        return ConsumerClient.build(client);
    }

    public ConsumerClient getClient(BrokerNode node) {
        Client client = this.clientManager.getClient(node);
        if (client == null) {
            return null;
        }
        return ConsumerClient.build(client);
    }

    public ConsumerClient tryGetClient(BrokerNode node) {
        Client client = this.clientManager.tryGetClient(node);
        if (client == null) {
            return null;
        }
        return ConsumerClient.build(client);
    }

    public void closeClient(BrokerNode node) {
        ConsumerClient consumerClient = this.tryGetClient(node);
        if (consumerClient == null) {
            return;
        }
        consumerClient.close();
        this.clientManager.closeClient(node);
    }

    protected void validate() throws Exception {
        this.clientManager = new ClientManager(this.transportConfig, this.nameServerConfig);
    }

    protected void doStart() throws Exception {
        this.clientManager.start();
    }

    protected void doStop() {
        if (this.clientManager != null) {
            this.clientManager.stop();
        }
    }
}

