/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.transport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.client.internal.consumer.transport.ConsumerClient;
import org.joyqueue.network.command.AddConsumerRequest;
import org.joyqueue.network.command.RemoveConsumerRequest;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerConnectionState {
    protected static final Logger logger = LoggerFactory.getLogger(ConsumerConnectionState.class);
    private static final AtomicLong SEQUENCE = new AtomicLong();
    private ConsumerClient consumerClient;
    private ConcurrentMap<String, Set<String>> consumerMap = Maps.newConcurrentMap();
    private ReentrantReadWriteLock consumerLock = new ReentrantReadWriteLock();

    public ConsumerConnectionState(ConsumerClient consumerClient) {
        this.consumerClient = consumerClient;
    }

    public void handleAddConsumers() {
        if (MapUtils.isEmpty(this.consumerMap)) {
            return;
        }
        try {
            for (Map.Entry entry : this.consumerMap.entrySet()) {
                this.doHandleAddConsumers(Lists.newArrayList((Iterable)((Iterable)entry.getValue())), (String)entry.getKey());
            }
        }
        catch (Exception e) {
            logger.error("add consumer exception, consumerMap: {}", this.consumerMap, (Object)e);
            this.consumerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddConsumers(Collection<String> topics, String app) {
        this.consumerLock.readLock().lock();
        try {
            Set<String> currentTopics = this.getOrCreateAddedTopicSet(app);
            LinkedList addTopics = null;
            for (String topic : topics) {
                if (currentTopics.contains(topic)) continue;
                if (addTopics == null) {
                    addTopics = Lists.newLinkedList();
                }
                addTopics.add(topic);
            }
            if (CollectionUtils.isEmpty(addTopics)) {
                return;
            }
            if (this.doHandleAddConsumers(addTopics, app)) {
                currentTopics.addAll(addTopics);
            }
        }
        finally {
            this.consumerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveConsumers(Collection<String> topics, String app) {
        this.consumerLock.writeLock().lock();
        try {
            Set<String> topicSet = this.getOrCreateAddedTopicSet(app);
            LinkedList removeTopics = null;
            for (String topic : topics) {
                if (!topicSet.contains(topic)) continue;
                if (removeTopics == null) {
                    removeTopics = Lists.newLinkedList();
                }
                removeTopics.add(topic);
            }
            if (CollectionUtils.isEmpty(removeTopics)) {
                return;
            }
            if (this.doHandleRemoveConsumers(removeTopics, app)) {
                topicSet.removeAll(removeTopics);
            }
        }
        finally {
            this.consumerLock.writeLock().unlock();
        }
    }

    public void handleRemoveConsumers() {
        if (MapUtils.isEmpty(this.consumerMap)) {
            return;
        }
        for (Map.Entry entry : this.consumerMap.entrySet()) {
            this.doHandleRemoveConsumers(Lists.newArrayList((Iterable)((Iterable)entry.getValue())), (String)entry.getKey());
        }
    }

    protected boolean doHandleAddConsumers(List<String> topics, String app) {
        AddConsumerRequest addConsumerRequest = new AddConsumerRequest();
        addConsumerRequest.setTopics(topics);
        addConsumerRequest.setApp(app);
        addConsumerRequest.setSequence(SEQUENCE.incrementAndGet());
        try {
            this.consumerClient.getClient().sync((Command)new JoyQueueCommand((JoyQueuePayload)addConsumerRequest));
            return true;
        }
        catch (Exception e) {
            logger.warn("add consumer exception, topics: {}, app: {}, error: {}", new Object[]{topics, app, e.getMessage()});
            logger.debug("add consumer exception, topics: {}, app: {}", new Object[]{topics, app, e});
            return false;
        }
    }

    protected boolean doHandleRemoveConsumers(List<String> topics, String app) {
        RemoveConsumerRequest removeConsumerRequest = new RemoveConsumerRequest();
        removeConsumerRequest.setTopics(topics);
        removeConsumerRequest.setApp(app);
        try {
            this.consumerClient.getClient().sync((Command)new JoyQueueCommand((JoyQueuePayload)removeConsumerRequest));
            return true;
        }
        catch (Exception e) {
            logger.warn("remove consumer exception, topics: {}, app: {}, error: {}", new Object[]{topics, app, e.getMessage()});
            logger.debug("remove consumer exception, topics: {}, app: {}", new Object[]{topics, app, e});
            return false;
        }
    }

    protected Set<String> getOrCreateAddedTopicSet(String app) {
        Set<String> oldTopicSet;
        Set<String> topicSet = (Set<String>)this.consumerMap.get(app);
        if (topicSet == null && (oldTopicSet = this.consumerMap.putIfAbsent(app, topicSet = Sets.newConcurrentHashSet())) != null) {
            topicSet = oldTopicSet;
        }
        return topicSet;
    }
}

