/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.metadata.converter.ClusterMetadataConverter;
import org.joyqueue.client.internal.metadata.domain.ClusterMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.network.command.FetchClusterResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataManager {
    protected static final Logger logger = LoggerFactory.getLogger(MetadataManager.class);
    private ClusterClientManager clusterClientManager;

    public MetadataManager(ClusterClientManager clusterClientManager) {
        this.clusterClientManager = clusterClientManager;
    }

    public TopicMetadata fetchMetadata(String topic, String app) {
        ClusterMetadata clusterMetadata = this.fetchMetadata(Lists.newArrayList((Object[])new String[]{topic}), app);
        return clusterMetadata.getTopic(topic);
    }

    public ClusterMetadata fetchMetadata(List<String> topics, String app) {
        FetchClusterResponse fetchClusterResponse = this.clusterClientManager.getOrCreateClient().fetchCluster(topics, app);
        if (logger.isDebugEnabled()) {
            logger.debug("fetch metadata, topics: {}, app: {}, metadata: {}", new Object[]{topics, app, fetchClusterResponse});
        }
        return ClusterMetadataConverter.convert(fetchClusterResponse);
    }
}

