/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.metadata.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.metadata.domain.ClusterMetadata;
import org.joyqueue.client.internal.metadata.domain.PartitionGroupMetadata;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchClusterResponse;
import org.joyqueue.network.command.Topic;
import org.joyqueue.network.command.TopicPartition;
import org.joyqueue.network.command.TopicPartitionGroup;
import org.joyqueue.network.domain.BrokerNode;

public class ClusterMetadataConverter {
    public static ClusterMetadata convert(FetchClusterResponse fetchClusterResponse) {
        LinkedHashMap topics = Maps.newLinkedHashMap();
        Map brokers = fetchClusterResponse.getBrokers();
        if (MapUtils.isNotEmpty((Map)fetchClusterResponse.getTopics())) {
            for (Map.Entry topicEntry : fetchClusterResponse.getTopics().entrySet()) {
                TopicMetadata topicMetadata = ClusterMetadataConverter.convertTopicMetadata((String)topicEntry.getKey(), (Topic)topicEntry.getValue(), fetchClusterResponse.getBrokers());
                topics.put(topicEntry.getKey(), topicMetadata);
            }
        }
        return new ClusterMetadata(topics, brokers);
    }

    public static TopicMetadata convertTopicMetadata(String code, Topic topic, Map<Integer, BrokerNode> brokerMap) {
        Map weightMap;
        if (!topic.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
            return new TopicMetadata(topic.getCode());
        }
        ArrayList partitionGroups = Lists.newArrayList();
        ArrayList partitions = Lists.newArrayList();
        HashMap partitionMap = Maps.newHashMap();
        HashMap partitionGroupMap = Maps.newHashMap();
        ArrayList brokers = Lists.newArrayList();
        ArrayList nearbyBrokers = Lists.newArrayList();
        HashMap brokerPartitions = Maps.newHashMap();
        HashMap brokerPartitionGroups = Maps.newHashMap();
        boolean allAvailable = true;
        for (Map.Entry<Integer, BrokerNode> entry : brokerMap.entrySet()) {
            BrokerNode brokerNode = entry.getValue();
            brokers.add(brokerNode);
            if (!brokerNode.isNearby()) continue;
            nearbyBrokers.add(brokerNode);
        }
        for (Map.Entry<Integer, Object> entry : topic.getPartitionGroups().entrySet()) {
            Object brokerPartitionGroupList;
            PartitionGroupMetadata partitionGroupMetadata = ClusterMetadataConverter.convertPartitionGroupMetadata(code, (TopicPartitionGroup)entry.getValue(), brokerMap);
            partitionGroups.add(partitionGroupMetadata);
            partitionGroupMap.put(entry.getKey(), partitionGroupMetadata);
            if (partitionGroupMetadata.getLeader() == null) {
                allAvailable = false;
            } else {
                if (!partitionGroupMetadata.getLeader().isWritable() || !partitionGroupMetadata.getLeader().isReadable()) {
                    allAvailable = false;
                }
                if ((brokerPartitionGroupList = (List)brokerPartitionGroups.get(partitionGroupMetadata.getLeader().getId())) == null) {
                    brokerPartitionGroupList = Lists.newArrayList();
                    brokerPartitionGroups.put(partitionGroupMetadata.getLeader().getId(), brokerPartitionGroupList);
                }
                brokerPartitionGroupList.add(partitionGroupMetadata);
            }
            brokerPartitionGroupList = partitionGroupMetadata.getPartitions().entrySet().iterator();
            while (brokerPartitionGroupList.hasNext()) {
                Map.Entry<Short, PartitionMetadata> partitionEntry = brokerPartitionGroupList.next();
                partitions.add(partitionEntry.getValue());
                partitionMap.put(partitionEntry.getKey(), partitionEntry.getValue());
                if (partitionEntry.getValue().getLeader() == null) continue;
                List brokerPartitionList = (List)brokerPartitions.get(partitionEntry.getValue().getLeader().getId());
                if (brokerPartitionList == null) {
                    brokerPartitionList = Lists.newArrayList();
                    brokerPartitions.put(partitionEntry.getValue().getLeader().getId(), brokerPartitionList);
                }
                brokerPartitionList.add(partitionEntry.getValue());
            }
        }
        if (topic.getProducerPolicy() != null && MapUtils.isNotEmpty((Map)(weightMap = topic.getProducerPolicy().getWeight()))) {
            for (Map.Entry entry : weightMap.entrySet()) {
                PartitionGroupMetadata partitionGroupMetadata;
                if (!StringUtils.isNumeric((CharSequence)((CharSequence)entry.getKey())) || (partitionGroupMetadata = (PartitionGroupMetadata)partitionGroupMap.get(Integer.valueOf((String)entry.getKey()))) == null || partitionGroupMetadata.getLeader() == null) continue;
                partitionGroupMetadata.getLeader().setWeight(partitionGroupMetadata.getLeader().getWeight() + (Short)entry.getValue());
            }
        }
        return new TopicMetadata(code, topic.getProducerPolicy(), topic.getConsumerPolicy(), topic.getType(), partitionGroups, partitions, partitionMap, partitionGroupMap, brokers, nearbyBrokers, brokerMap, brokerPartitions, brokerPartitionGroups, allAvailable, topic.getCode());
    }

    public static PartitionGroupMetadata convertPartitionGroupMetadata(String topic, TopicPartitionGroup partitionGroup, Map<Integer, BrokerNode> brokers) {
        LinkedHashMap partitions = Maps.newLinkedHashMap();
        BrokerNode leader = brokers.get(partitionGroup.getLeader());
        for (Map.Entry entry : partitionGroup.getPartitions().entrySet()) {
            PartitionMetadata partitionMetadata = ClusterMetadataConverter.convertPartitionMetadata(topic, (TopicPartition)entry.getValue(), partitionGroup.getId(), leader);
            partitions.put(entry.getKey(), partitionMetadata);
        }
        return new PartitionGroupMetadata(partitionGroup.getId(), leader, partitions);
    }

    public static PartitionMetadata convertPartitionMetadata(String topic, TopicPartition topicPartition, int partitionGroupId, BrokerNode leader) {
        return new PartitionMetadata(topicPartition.getId(), partitionGroupId, topic, leader);
    }
}

