/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.metadata.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.joyqueue.client.internal.metadata.domain.PartitionGroupMetadata;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.UnmodifiableTopicMetadata;
import org.joyqueue.domain.ConsumerPolicy;
import org.joyqueue.domain.ProducerPolicy;
import org.joyqueue.domain.TopicType;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.domain.BrokerNode;

public class TopicMetadata
implements Serializable {
    private String topic;
    private ProducerPolicy producerPolicy;
    private ConsumerPolicy consumerPolicy;
    private TopicType type;
    private JoyQueueCode code;
    private List<PartitionGroupMetadata> partitionGroups;
    private List<PartitionMetadata> partitions;
    private Map<Short, PartitionMetadata> partitionMap;
    private Map<Integer, PartitionGroupMetadata> partitionGroupMap;
    private List<BrokerNode> brokers;
    private List<BrokerNode> nearbyBrokers;
    private Map<Integer, BrokerNode> brokerMap;
    private Map<Integer, List<PartitionMetadata>> brokerPartitions;
    private Map<Integer, List<PartitionGroupMetadata>> brokerPartitionGroups;
    private boolean allAvailable = false;
    @Deprecated
    private TopicMetadata unmodifiableTopicMetadata;

    public TopicMetadata() {
    }

    public TopicMetadata(JoyQueueCode code) {
        this.code = code;
    }

    public TopicMetadata(String topic, ProducerPolicy producerPolicy, ConsumerPolicy consumerPolicy, TopicType type, List<PartitionGroupMetadata> partitionGroups, List<PartitionMetadata> partitions, Map<Short, PartitionMetadata> partitionMap, Map<Integer, PartitionGroupMetadata> partitionGroupMap, List<BrokerNode> brokers, List<BrokerNode> nearbyBrokers, Map<Integer, BrokerNode> brokerMap, Map<Integer, List<PartitionMetadata>> brokerPartitions, Map<Integer, List<PartitionGroupMetadata>> brokerPartitionGroups, boolean allAvailable, JoyQueueCode code) {
        this.topic = topic;
        this.producerPolicy = producerPolicy;
        this.consumerPolicy = consumerPolicy;
        this.type = type;
        this.partitionGroups = partitionGroups;
        this.partitions = partitions;
        this.partitionMap = partitionMap;
        this.partitionGroupMap = partitionGroupMap;
        this.brokers = brokers;
        this.nearbyBrokers = nearbyBrokers;
        this.brokerMap = brokerMap;
        this.brokerPartitions = brokerPartitions;
        this.brokerPartitionGroups = brokerPartitionGroups;
        this.allAvailable = allAvailable;
        this.code = code;
    }

    @Deprecated
    public TopicMetadata clone() {
        if (this.unmodifiableTopicMetadata != null) {
            return this.unmodifiableTopicMetadata;
        }
        ProducerPolicy newProducerPolicy = null;
        ConsumerPolicy newConsumerPolicy = null;
        if (this.producerPolicy != null) {
            newProducerPolicy = new ProducerPolicy(this.producerPolicy.getNearby(), this.producerPolicy.getSingle(), this.producerPolicy.getArchive(), this.producerPolicy.getWeight(), this.producerPolicy.getBlackList(), this.producerPolicy.getTimeOut());
        }
        if (this.consumerPolicy != null) {
            newConsumerPolicy = new ConsumerPolicy(this.consumerPolicy.getNearby(), this.consumerPolicy.getPaused(), this.consumerPolicy.getArchive(), this.consumerPolicy.getRetry(), this.consumerPolicy.getSeq(), this.consumerPolicy.getAckTimeout(), this.consumerPolicy.getBatchSize(), this.consumerPolicy.getConcurrent(), this.consumerPolicy.getDelay(), this.consumerPolicy.getBlackList(), this.consumerPolicy.getErrTimes(), this.consumerPolicy.getMaxPartitionNum(), this.consumerPolicy.getReadRetryProbability(), null);
        }
        this.unmodifiableTopicMetadata = new UnmodifiableTopicMetadata(this.topic, newProducerPolicy, newConsumerPolicy, this.type, this.partitionGroups, this.partitions, this.partitionMap, this.partitionGroupMap, this.brokers, this.nearbyBrokers, this.brokerMap, this.brokerPartitions, this.brokerPartitionGroups, this.allAvailable, this.code);
        return this.unmodifiableTopicMetadata;
    }

    public String getTopic() {
        return this.topic;
    }

    public ProducerPolicy getProducerPolicy() {
        return this.producerPolicy;
    }

    public ConsumerPolicy getConsumerPolicy() {
        return this.consumerPolicy;
    }

    public TopicType getType() {
        return this.type;
    }

    public List<PartitionMetadata> getPartitions() {
        return this.partitions;
    }

    public List<PartitionGroupMetadata> getPartitionGroups() {
        return this.partitionGroups;
    }

    public List<BrokerNode> getBrokers() {
        return this.brokers;
    }

    public List<BrokerNode> getNearbyBrokers() {
        return this.nearbyBrokers;
    }

    public List<PartitionGroupMetadata> getBrokerPartitionGroups(int brokerId) {
        return this.brokerPartitionGroups.get(brokerId);
    }

    public List<PartitionMetadata> getBrokerPartitions(int brokerId) {
        return this.brokerPartitions.get(brokerId);
    }

    public BrokerNode getBroker(int brokerId) {
        return this.brokerMap.get(brokerId);
    }

    public PartitionGroupMetadata getPartitionGroup(int partitionGroup) {
        return this.partitionGroupMap.get(partitionGroup);
    }

    public PartitionMetadata getPartition(short partition) {
        return this.partitionMap.get(partition);
    }

    public boolean isAllAvailable() {
        return this.allAvailable;
    }

    public JoyQueueCode getCode() {
        return this.code;
    }

    public String toString() {
        return "TopicMetadata{topic='" + this.topic + '\'' + ", producerPolicy=" + this.producerPolicy + ", consumerPolicy=" + this.consumerPolicy + ", type=" + this.type + ", partitionGroups=" + this.partitionGroups + ", partitions=" + this.partitions + ", code=" + this.code + '}';
    }
}

