/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.nameserver;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.nameserver.NameServerConfig;

public class NameServerConfigChecker {
    public static void check(NameServerConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"nameserver can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getAddress()), (Object)"nameserver.address can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getApp()), (Object)"nameserver.app can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getToken()), (Object)"nameserver.token can not be null");
        Preconditions.checkArgument((config.getUpdateMetadataInterval() > 0 ? 1 : 0) != 0, (Object)"nameserver.updateMetadataInterval must be greater than 0");
        Preconditions.checkArgument((config.getTempMetadataInterval() > 0 ? 1 : 0) != 0, (Object)"nameserver.tempMetadataInterval must be greater than 0");
        Preconditions.checkArgument((config.getUpdateMetadataThread() > 0 ? 1 : 0) != 0, (Object)"nameserver.updateMetadataThread must be greater than 0");
        Preconditions.checkArgument((config.getUpdateMetadataQueueSize() > 0 ? 1 : 0) != 0, (Object)"nameserver.updateMetadataQueueSize must be greater than 0");
    }
}

