/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer;

import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.cluster.ClusterManagerFactory;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.support.DefaultMessageProducer;
import org.joyqueue.client.internal.producer.support.MessageProducerWrapper;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.client.internal.producer.transport.ProducerClientManagerFactory;
import org.joyqueue.client.internal.transport.config.TransportConfig;

public class MessageProducerFactory {
    public static MessageProducer create(String address, String app, String token) {
        return MessageProducerFactory.create(address, app, token, null, null);
    }

    public static MessageProducer create(String address, String app, String token, String region) {
        return MessageProducerFactory.create(address, app, token, region, null);
    }

    public static MessageProducer create(String address, String app, String token, String region, String namespace) {
        ProducerConfig producerConfig = new ProducerConfig();
        producerConfig.setApp(app);
        NameServerConfig nameServerConfig = NameServerHelper.createConfig(address, app, token, region, namespace);
        return MessageProducerFactory.create(producerConfig, nameServerConfig);
    }

    public static MessageProducer create(ProducerConfig producerConfig, NameServerConfig nameServerConfig) {
        return MessageProducerFactory.create(producerConfig, nameServerConfig, new TransportConfig());
    }

    public static MessageProducer create(ProducerConfig producerConfig, NameServerConfig nameServerConfig, TransportConfig transportConfig) {
        ClusterManager clusterManager = ClusterManagerFactory.create(nameServerConfig, transportConfig);
        ProducerClientManager producerClientManager = ProducerClientManagerFactory.create(nameServerConfig, transportConfig);
        DefaultMessageProducer messageProducer = new DefaultMessageProducer(producerConfig, nameServerConfig, clusterManager, producerClientManager);
        return new MessageProducerWrapper(clusterManager, producerClientManager, messageProducer);
    }

    public static MessageProducer create(ProducerConfig producerConfig, NameServerConfig nameServerConfig, ProducerClientManager producerClientManager) {
        return MessageProducerFactory.create(producerConfig, nameServerConfig, new TransportConfig(), producerClientManager);
    }

    public static MessageProducer create(ProducerConfig producerConfig, NameServerConfig nameServerConfig, TransportConfig transportConfig, ProducerClientManager producerClientManager) {
        ClusterManager clusterManager = ClusterManagerFactory.create(nameServerConfig, transportConfig);
        DefaultMessageProducer messageProducer = new DefaultMessageProducer(producerConfig, nameServerConfig, clusterManager, producerClientManager);
        return new MessageProducerWrapper(clusterManager, null, messageProducer);
    }

    public static MessageProducer create(ProducerConfig producerConfig, NameServerConfig nameServerConfig, ClusterClientManager clusterClientManager, ProducerClientManager producerClientManager) {
        ClusterManager clusterManager = ClusterManagerFactory.create(nameServerConfig, clusterClientManager);
        DefaultMessageProducer messageProducer = new DefaultMessageProducer(producerConfig, nameServerConfig, clusterManager, producerClientManager);
        return new MessageProducerWrapper(clusterManager, null, messageProducer);
    }

    public static MessageProducer create(ProducerConfig producerConfig, NameServerConfig nameServerConfig, ClusterManager clusterManager, ProducerClientManager producerClientManager) {
        return new DefaultMessageProducer(producerConfig, nameServerConfig, clusterManager, producerClientManager);
    }
}

