/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer;

import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.MessageSenderWrapper;
import org.joyqueue.client.internal.producer.config.SenderConfig;
import org.joyqueue.client.internal.producer.support.DefaultMessageSender;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.client.internal.producer.transport.ProducerClientManagerFactory;
import org.joyqueue.client.internal.transport.config.TransportConfig;

public class MessageSenderFactory {
    public static MessageSender create(String address, String app, String token) {
        return MessageSenderFactory.create(address, app, token, null, null);
    }

    public static MessageSender create(String address, String app, String token, String region) {
        return MessageSenderFactory.create(address, app, token, region, null);
    }

    public static MessageSender create(String address, String app, String token, String region, String namespace) {
        NameServerConfig nameServerConfig = NameServerHelper.createConfig(address, app, token, region, namespace);
        return MessageSenderFactory.create(nameServerConfig);
    }

    public static MessageSender create(NameServerConfig nameServerConfig) {
        return MessageSenderFactory.create(nameServerConfig, new SenderConfig());
    }

    public static MessageSender create(NameServerConfig nameServerConfig, SenderConfig config) {
        return MessageSenderFactory.create(nameServerConfig, new TransportConfig(), config);
    }

    public static MessageSender create(NameServerConfig nameServerConfig, TransportConfig transportConfig, SenderConfig config) {
        ProducerClientManager producerClientManager = ProducerClientManagerFactory.create(nameServerConfig, transportConfig);
        DefaultMessageSender messageSender = new DefaultMessageSender(producerClientManager, config);
        return new MessageSenderWrapper(producerClientManager, messageSender);
    }

    public static MessageSender create(ProducerClientManager producerClientManager, SenderConfig config) {
        return new DefaultMessageSender(producerClientManager, config);
    }
}

