/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.callback.AsyncBatchSendCallback;
import org.joyqueue.client.internal.producer.callback.AsyncMultiBatchSendCallback;
import org.joyqueue.client.internal.producer.callback.AsyncSendCallback;
import org.joyqueue.client.internal.producer.domain.FetchFeedbackData;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendBatchResultData;
import org.joyqueue.client.internal.producer.domain.SendPrepareResult;
import org.joyqueue.client.internal.producer.domain.SendResultData;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.TxStatus;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;

public class MessageSenderWrapper
extends Service
implements MessageSender {
    private ProducerClientManager producerClientManager;
    private MessageSender delegate;

    public MessageSenderWrapper(ProducerClientManager producerClientManager, MessageSender delegate) {
        this.producerClientManager = producerClientManager;
        this.delegate = delegate;
    }

    protected void doStart() throws Exception {
        this.producerClientManager.start();
        this.delegate.start();
    }

    protected void doStop() {
        this.delegate.stop();
        this.producerClientManager.stop();
    }

    @Override
    public SendResultData send(BrokerNode brokerNode, String topic, String app, String txId, ProduceMessage message, QosLevel qosLevel, long produceTimeout, long timeout) {
        return this.delegate.send(brokerNode, topic, app, txId, message, qosLevel, produceTimeout, timeout);
    }

    @Override
    public SendBatchResultData batchSend(BrokerNode brokerNode, String topic, String app, String txId, List<ProduceMessage> messages, QosLevel qosLevel, long produceTimeout, long timeout) {
        return this.delegate.batchSend(brokerNode, topic, app, txId, messages, qosLevel, produceTimeout, timeout);
    }

    @Override
    public CompletableFuture<SendBatchResultData> batchSendAsync(BrokerNode brokerNode, String topic, String app, String txId, List<ProduceMessage> messages, QosLevel qosLevel, long produceTimeout, long timeout) {
        return this.delegate.batchSendAsync(brokerNode, topic, app, txId, messages, qosLevel, produceTimeout, timeout);
    }

    @Override
    public void sendAsync(BrokerNode brokerNode, String topic, String app, String txId, ProduceMessage message, QosLevel qosLevel, long produceTimeout, long timeout, AsyncSendCallback callback) {
        this.delegate.sendAsync(brokerNode, topic, app, txId, message, qosLevel, produceTimeout, timeout, callback);
    }

    @Override
    public void sendOneway(BrokerNode brokerNode, String topic, String app, String txId, ProduceMessage message, QosLevel qosLevel, long produceTimeout, long timeout) {
        this.delegate.sendOneway(brokerNode, topic, app, txId, message, qosLevel, produceTimeout, timeout);
    }

    @Override
    public void batchSendOneway(BrokerNode brokerNode, String app, String txId, Map<String, List<ProduceMessage>> messages, QosLevel qosLevel, long produceTimeout, long timeout) {
        this.delegate.batchSendOneway(brokerNode, app, txId, messages, qosLevel, produceTimeout, timeout);
    }

    @Override
    public void batchSendOneway(BrokerNode brokerNode, String topic, String app, String txId, List<ProduceMessage> messages, QosLevel qosLevel, long produceTimeout, long timeout) {
        this.delegate.batchSendOneway(brokerNode, topic, app, txId, messages, qosLevel, produceTimeout, timeout);
    }

    @Override
    public void batchSendAsync(BrokerNode brokerNode, String topic, String app, String txId, List<ProduceMessage> messages, QosLevel qosLevel, long produceTimeout, long timeout, AsyncBatchSendCallback callback) {
        this.delegate.batchSendAsync(brokerNode, topic, app, txId, messages, qosLevel, produceTimeout, timeout, callback);
    }

    @Override
    public Map<String, SendBatchResultData> batchSend(BrokerNode brokerNode, String app, String txId, Map<String, List<ProduceMessage>> messages, QosLevel qosLevel, long produceTimeout, long timeout) {
        return this.delegate.batchSend(brokerNode, app, txId, messages, qosLevel, produceTimeout, timeout);
    }

    @Override
    public void batchSendAsync(BrokerNode brokerNode, String app, String txId, Map<String, List<ProduceMessage>> messages, QosLevel qosLevel, long produceTimeout, long timeout, AsyncMultiBatchSendCallback callback) {
        this.delegate.batchSendAsync(brokerNode, app, txId, messages, qosLevel, produceTimeout, timeout, callback);
    }

    @Override
    public CompletableFuture<Map<String, SendBatchResultData>> batchSendAsync(BrokerNode brokerNode, String app, String txId, Map<String, List<ProduceMessage>> messages, QosLevel qosLevel, long produceTimeout, long timeout) {
        return this.delegate.batchSendAsync(brokerNode, app, txId, messages, qosLevel, produceTimeout, timeout);
    }

    @Override
    public SendPrepareResult prepare(BrokerNode brokerNode, String topic, String app, String transactionId, long sequence, long transactionTimeout, long timeout) {
        return this.delegate.prepare(brokerNode, topic, app, transactionId, sequence, transactionTimeout, timeout);
    }

    @Override
    public JoyQueueCode commit(BrokerNode brokerNode, String topic, String app, String txId, long timeout) {
        return this.delegate.commit(brokerNode, topic, app, txId, timeout);
    }

    @Override
    public JoyQueueCode rollback(BrokerNode brokerNode, String topic, String app, String txId, long timeout) {
        return this.delegate.rollback(brokerNode, topic, app, txId, timeout);
    }

    @Override
    public FetchFeedbackData fetchFeedback(BrokerNode brokerNode, String topic, String app, TxStatus txStatus, int count, long longPollTimeout, long timeout) {
        return this.delegate.fetchFeedback(brokerNode, topic, app, txStatus, count, longPollTimeout, timeout);
    }
}

