/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer;

import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.cluster.ClusterManagerFactory;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.MessageSenderFactory;
import org.joyqueue.client.internal.producer.TxFeedbackManager;
import org.joyqueue.client.internal.producer.config.SenderConfig;
import org.joyqueue.client.internal.producer.feedback.DefaultTxFeedbackManager;
import org.joyqueue.client.internal.producer.feedback.TxFeedbackManagerWrapper;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.client.internal.producer.transport.ProducerClientManagerFactory;
import org.joyqueue.client.internal.transport.config.TransportConfig;

public class TxFeedbackManagerFactory {
    public static TxFeedbackManager create(String address, String app, String token) {
        return TxFeedbackManagerFactory.create(address, app, token, null, null);
    }

    public static TxFeedbackManager create(String address, String app, String token, String region, String namespace) {
        TxFeedbackConfig txFeedbackConfig = new TxFeedbackConfig();
        txFeedbackConfig.setApp(app);
        NameServerConfig nameServerConfig = NameServerHelper.createConfig(address, app, token, region, namespace);
        return TxFeedbackManagerFactory.create(txFeedbackConfig, nameServerConfig);
    }

    public static TxFeedbackManager create(TxFeedbackConfig config, NameServerConfig nameServerConfig) {
        return TxFeedbackManagerFactory.create(config, nameServerConfig, new TransportConfig());
    }

    public static TxFeedbackManager create(TxFeedbackConfig config, NameServerConfig nameServerConfig, TransportConfig transportConfig) {
        ClusterManager clusterManager = ClusterManagerFactory.create(nameServerConfig, transportConfig);
        ProducerClientManager producerClientManager = ProducerClientManagerFactory.create(nameServerConfig, transportConfig);
        return TxFeedbackManagerFactory.create(config, nameServerConfig, clusterManager, producerClientManager);
    }

    public static TxFeedbackManager create(TxFeedbackConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager) {
        return TxFeedbackManagerFactory.create(config, nameServerConfig, new TransportConfig(), clusterManager);
    }

    public static TxFeedbackManager create(TxFeedbackConfig config, NameServerConfig nameServerConfig, TransportConfig transportConfig, ClusterManager clusterManager) {
        ProducerClientManager producerClientManager = ProducerClientManagerFactory.create(nameServerConfig, transportConfig);
        return TxFeedbackManagerFactory.create(config, nameServerConfig, clusterManager, producerClientManager);
    }

    public static TxFeedbackManager create(TxFeedbackConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ProducerClientManager producerClientManager) {
        MessageSender messageSender = MessageSenderFactory.create(producerClientManager, new SenderConfig());
        DefaultTxFeedbackManager txFeedbackManager = new DefaultTxFeedbackManager(config, nameServerConfig, clusterManager, messageSender);
        return new TxFeedbackManagerWrapper(null, null, messageSender, txFeedbackManager);
    }
}

