/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.checker;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.exception.ProducerException;
import org.joyqueue.exception.JoyQueueCode;

public class ProduceMessageChecker {
    public static void checkMessage(ProduceMessage produceMessage, ProducerConfig config) {
        if (produceMessage == null) {
            ProduceMessageChecker.throwCheckException("message not null");
        }
        if (StringUtils.isBlank((CharSequence)produceMessage.getTopic())) {
            ProduceMessageChecker.throwCheckException("message topic is not empty");
        }
        if (StringUtils.isBlank((CharSequence)produceMessage.getBody()) && ArrayUtils.isEmpty((byte[])produceMessage.getBodyBytes())) {
            ProduceMessageChecker.throwCheckException("message body is not empty");
        }
        if (produceMessage.getPartition() != Short.MIN_VALUE && produceMessage.getPartition() < 0) {
            ProduceMessageChecker.throwCheckException("message body is not exist");
        }
        if (StringUtils.isNotBlank((CharSequence)produceMessage.getBody()) && produceMessage.getBody().length() > config.getBodyLengthLimit()) {
            ProduceMessageChecker.throwCheckException(String.format("body is too long, it must less than %s characters", config.getBodyLengthLimit()));
        }
        if (ArrayUtils.isNotEmpty((byte[])produceMessage.getBodyBytes()) && produceMessage.getBodyBytes().length > config.getBodyLengthLimit()) {
            ProduceMessageChecker.throwCheckException(String.format("bodyBytes is too long, it must less than %s characters", config.getBodyLengthLimit()));
        }
        if (StringUtils.isNotBlank((CharSequence)produceMessage.getBusinessId()) && produceMessage.getBusinessId().length() > config.getBusinessIdLengthLimit()) {
            ProduceMessageChecker.throwCheckException(String.format("businessId is too long, it must less than %s characters", config.getBusinessIdLengthLimit()));
        }
    }

    public static void checkMessages(List<ProduceMessage> produceMessages, ProducerConfig config) {
        String topic = null;
        short partition = -1;
        int length = 0;
        for (ProduceMessage produceMessage : produceMessages) {
            ProduceMessageChecker.checkMessage(produceMessage, config);
            if (topic == null) {
                topic = produceMessage.getTopic();
            } else if (!produceMessage.getTopic().equals(topic)) {
                ProduceMessageChecker.throwCheckException("batch messages must single topic");
            }
            if (partition == -1) {
                partition = produceMessage.getPartition();
            } else if (produceMessage.getPartition() != partition) {
                ProduceMessageChecker.throwCheckException("batch messages must single partition");
            }
            if (StringUtils.isNotBlank((CharSequence)produceMessage.getBody())) {
                length += produceMessage.getBody().length();
                continue;
            }
            length += produceMessage.getBodyBytes().length;
        }
        if (length > config.getBatchBodyLengthLimit()) {
            ProduceMessageChecker.throwCheckException(String.format("messages body is too long, it must less than %s characters", config.getBatchBodyLengthLimit()));
        }
    }

    protected static void throwCheckException(String message) {
        throw new ProducerException(message, JoyQueueCode.CN_PARAM_ERROR.getCode());
    }
}

