/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.config;

import org.joyqueue.domain.QosLevel;
import org.joyqueue.toolkit.retry.RetryPolicy;

public class ProducerConfig {
    public static final long NONE_PRODUCE_TIMEOUT = -1L;
    private String app;
    private long timeout = 3000L;
    private long produceTimeout = 3000L;
    private long transactionTimeout = 1800000L;
    private boolean failover = true;
    private RetryPolicy retryPolicy = new RetryPolicy(Integer.valueOf(1000), Integer.valueOf(2));
    private QosLevel qosLevel = QosLevel.REPLICATION;
    private boolean compress = true;
    private String compressType = "zlib";
    private int compressThreshold = 100;
    private boolean batch = true;
    private String selectorType = "roundrobin";
    private int businessIdLengthLimit = 100;
    private int bodyLengthLimit = 0x100000;
    private int batchBodyLengthLimit = 0x400000;

    public ProducerConfig copy() {
        ProducerConfig producerConfig = new ProducerConfig();
        producerConfig.setApp(this.app);
        producerConfig.setTimeout(this.timeout);
        producerConfig.setProduceTimeout(this.produceTimeout);
        producerConfig.setTransactionTimeout(this.transactionTimeout);
        producerConfig.setFailover(this.failover);
        producerConfig.setRetryPolicy(this.retryPolicy);
        producerConfig.setQosLevel(this.qosLevel);
        producerConfig.setCompress(this.compress);
        producerConfig.setCompressType(this.compressType);
        producerConfig.setCompressThreshold(this.compressThreshold);
        producerConfig.setBatch(this.batch);
        producerConfig.setSelectorType(this.selectorType);
        producerConfig.setBusinessIdLengthLimit(this.businessIdLengthLimit);
        producerConfig.setBodyLengthLimit(this.bodyLengthLimit);
        producerConfig.setBatchBodyLengthLimit(this.batchBodyLengthLimit);
        return producerConfig;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getProduceTimeout() {
        return this.produceTimeout;
    }

    public void setProduceTimeout(long produceTimeout) {
        this.produceTimeout = produceTimeout;
    }

    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public QosLevel getQosLevel() {
        return this.qosLevel;
    }

    public void setQosLevel(QosLevel qosLevel) {
        this.qosLevel = qosLevel;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompressType(String compressType) {
        this.compressType = compressType;
    }

    public String getCompressType() {
        return this.compressType;
    }

    public void setCompressThreshold(int compressThreshold) {
        this.compressThreshold = compressThreshold;
    }

    public int getCompressThreshold() {
        return this.compressThreshold;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public String getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorType(String selectorType) {
        this.selectorType = selectorType;
    }

    public int getBusinessIdLengthLimit() {
        return this.businessIdLengthLimit;
    }

    public void setBusinessIdLengthLimit(int businessIdLengthLimit) {
        this.businessIdLengthLimit = businessIdLengthLimit;
    }

    public int getBodyLengthLimit() {
        return this.bodyLengthLimit;
    }

    public void setBodyLengthLimit(int bodyLengthLimit) {
        this.bodyLengthLimit = bodyLengthLimit;
    }

    public int getBatchBodyLengthLimit() {
        return this.batchBodyLengthLimit;
    }

    public void setBatchBodyLengthLimit(int batchBodyLengthLimit) {
        this.batchBodyLengthLimit = batchBodyLengthLimit;
    }
}

