/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.producer.converter.ProduceMessageConverter;
import org.joyqueue.client.internal.producer.domain.FeedbackData;
import org.joyqueue.client.internal.producer.domain.FetchFeedbackData;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendBatchResultData;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.network.command.FetchProduceFeedbackAckData;
import org.joyqueue.network.command.FetchProduceFeedbackResponse;
import org.joyqueue.network.command.ProduceMessageAckData;
import org.joyqueue.network.command.ProduceMessageAckItemData;
import org.joyqueue.network.command.ProduceMessageData;

public class MessageSenderConverter {
    public static FetchFeedbackData convertToFetchFeedbackData(String topic, String app, FetchProduceFeedbackResponse fetchProduceFeedbackResponse) {
        FetchFeedbackData fetchFeedbackData = new FetchFeedbackData();
        if (CollectionUtils.isNotEmpty((Collection)fetchProduceFeedbackResponse.getData())) {
            ArrayList data = Lists.newArrayListWithCapacity((int)fetchProduceFeedbackResponse.getData().size());
            for (FetchProduceFeedbackAckData ackData : fetchProduceFeedbackResponse.getData()) {
                data.add(new FeedbackData(ackData.getTopic(), ackData.getTxId(), ackData.getTransactionId()));
            }
            fetchFeedbackData.setData(data);
        }
        fetchFeedbackData.setCode(fetchProduceFeedbackResponse.getCode());
        return fetchFeedbackData;
    }

    public static SendBatchResultData convertToBatchResultData(String topic, String app, ProduceMessageAckData produceMessageAckData) {
        SendBatchResultData sendBatchResultData = new SendBatchResultData();
        if (CollectionUtils.isNotEmpty((Collection)produceMessageAckData.getItem())) {
            ArrayList produceResultList = Lists.newArrayListWithCapacity((int)produceMessageAckData.getItem().size());
            for (ProduceMessageAckItemData produceMessageAckItemData : produceMessageAckData.getItem()) {
                SendResult produceResult = new SendResult(topic, produceMessageAckItemData.getPartition(), produceMessageAckItemData.getIndex(), produceMessageAckItemData.getStartTime());
                produceResultList.add(produceResult);
            }
            sendBatchResultData.setResult(produceResultList);
        }
        sendBatchResultData.setCode(produceMessageAckData.getCode());
        return sendBatchResultData;
    }

    public static ProduceMessageData convertToProduceMessageData(String topic, String app, String txId, List<ProduceMessage> messages, QosLevel qosLevel, long timeout, boolean compress, int compressThreshold, String compressType, boolean batch) {
        List<BrokerMessage> brokerMessages = ProduceMessageConverter.convertToBrokerMessages(topic, app, messages, compress, compressThreshold, compressType, batch);
        ProduceMessageData produceMessageData = new ProduceMessageData();
        produceMessageData.setQosLevel(qosLevel);
        produceMessageData.setMessages(brokerMessages);
        produceMessageData.setTxId(txId);
        produceMessageData.setTimeout((int)timeout);
        return produceMessageData;
    }
}

