/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.domain;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public class ProduceMessage
implements Serializable {
    public static final short NONE_PARTITION = Short.MIN_VALUE;
    public static final String NONE_PARTITION_KEY = null;
    private String topic;
    private String body;
    private byte[] bodyBytes;
    private short partition = Short.MIN_VALUE;
    private String partitionKey = NONE_PARTITION_KEY;
    private String businessId;
    private byte priority;
    private short flag;
    private Map<String, String> attributes;

    public ProduceMessage() {
    }

    public ProduceMessage(String topic, String body) {
        this.topic = topic;
        this.body = body;
    }

    public ProduceMessage(String topic, String body, String businessId) {
        this.topic = topic;
        this.body = body;
        this.businessId = businessId;
    }

    public ProduceMessage(String topic, String body, String businessId, String partitionKey) {
        this.topic = topic;
        this.body = body;
        this.businessId = businessId;
        this.partitionKey = partitionKey;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    public short getPartition() {
        return this.partition;
    }

    public void setPartition(short partition) {
        this.partition = partition;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setFlag(short flag) {
        this.flag = flag;
    }

    public short getFlag() {
        return this.flag;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean putAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        return this.attributes.put(key, value) != null;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public boolean containsAttribute(String key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(key);
    }

    public String toString() {
        return "ProduceMessage{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", partitionKey='" + this.partitionKey + '\'' + ", businessId='" + this.businessId + '\'' + ", flag='" + this.flag + '\'' + '}';
    }
}

