/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.feedback;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.TxFeedbackManager;
import org.joyqueue.client.internal.producer.callback.TxFeedbackCallback;
import org.joyqueue.client.internal.producer.exception.ProducerException;
import org.joyqueue.client.internal.producer.feedback.TxFeedbackScheduler;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTxFeedbackManager
extends Service
implements TxFeedbackManager {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultTxFeedbackManager.class);
    private TxFeedbackConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private MessageSender messageSender;
    private ConcurrentMap<String, TxFeedbackScheduler> txCallback = Maps.newConcurrentMap();

    public DefaultTxFeedbackManager(TxFeedbackConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, MessageSender messageSender) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"feedback not null");
        Preconditions.checkArgument((nameServerConfig != null ? 1 : 0) != 0, (Object)"nameServer not null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager not null");
        Preconditions.checkArgument((messageSender != null ? 1 : 0) != 0, (Object)"messageSender not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getApp()), (Object)"feedback.app not blank");
        Preconditions.checkArgument((config.getTimeout() > config.getLongPollTimeout() ? 1 : 0) != 0, (Object)"feedback.pollTimeout must be greater than consumer.longPullTimeout");
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.messageSender = messageSender;
    }

    protected void doStart() throws Exception {
        for (Map.Entry entry : this.txCallback.entrySet()) {
            if (((TxFeedbackScheduler)((Object)entry.getValue())).isStarted()) continue;
            ((TxFeedbackScheduler)((Object)entry.getValue())).start();
        }
    }

    protected void doStop() {
        for (Map.Entry entry : this.txCallback.entrySet()) {
            ((TxFeedbackScheduler)((Object)entry.getValue())).stop();
        }
        logger.info("txFeedbackManager is stopped");
    }

    @Override
    public synchronized void setTransactionCallback(String topic, TxFeedbackCallback callback) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        Preconditions.checkArgument((callback != null ? 1 : 0) != 0, (Object)"callback not null");
        this.checkTopicMetadata(topic);
        String topicFullName = this.getTopicFullName(topic);
        if (this.txCallback.containsKey(topicFullName)) {
            throw new IllegalArgumentException(String.format("%s feedback is exist", topic));
        }
        TxFeedbackScheduler txFeedbackScheduler = new TxFeedbackScheduler(this.config, topicFullName, callback, this.messageSender, this.clusterManager);
        if (this.isStarted()) {
            try {
                txFeedbackScheduler.start();
            }
            catch (Exception e) {
                logger.error("start feedback callback exception, topic: {}, app: {}", new Object[]{topic, this.config.getApp(), e});
                throw new ProducerException("start feedback callback exception", JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
            }
        }
        this.txCallback.put(topic, txFeedbackScheduler);
    }

    @Override
    public synchronized void removeTransactionCallback(String topic) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        String topicFullName = this.getTopicFullName(topic);
        TxFeedbackScheduler txFeedbackScheduler = (TxFeedbackScheduler)((Object)this.txCallback.get(topicFullName));
        if (txFeedbackScheduler == null) {
            throw new IllegalArgumentException(String.format("%s feedback is not exist", topic));
        }
        if (txFeedbackScheduler.isStarted()) {
            txFeedbackScheduler.stop();
        }
        this.txCallback.remove(topic);
    }

    protected TopicMetadata checkTopicMetadata(String topic) {
        TopicMetadata topicMetadata = this.clusterManager.fetchTopicMetadata(this.getTopicFullName(topic), this.config.getApp());
        if (topicMetadata == null) {
            throw new ProducerException(String.format("topic %s is not exist", topic), JoyQueueCode.FW_TOPIC_NOT_EXIST.getCode());
        }
        if (topicMetadata.getProducerPolicy() == null) {
            throw new ProducerException(String.format("topic %s producer %s is not exist", topic, this.config.getApp()), JoyQueueCode.FW_PRODUCER_NOT_EXISTS.getCode());
        }
        return topicMetadata;
    }

    protected String getTopicFullName(String topic) {
        return NameServerHelper.getTopicFullName(topic, this.nameServerConfig);
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new UnsupportedOperationException("txFeedbackManager is not started");
        }
    }
}

