/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.feedback;

import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.callback.TxFeedbackCallback;
import org.joyqueue.client.internal.producer.domain.FeedbackData;
import org.joyqueue.client.internal.producer.domain.FetchFeedbackData;
import org.joyqueue.client.internal.producer.domain.TransactionStatus;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.TxStatus;
import org.joyqueue.network.domain.BrokerNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxFeedbackDispatcher {
    protected static final Logger logger = LoggerFactory.getLogger(TxFeedbackDispatcher.class);
    private TxFeedbackConfig config;
    private String topic;
    private TxFeedbackCallback txFeedbackCallback;
    private MessageSender messageSender;
    private ClusterManager clusterManager;

    public TxFeedbackDispatcher(TxFeedbackConfig config, String topic, TxFeedbackCallback txFeedbackCallback, MessageSender messageSender, ClusterManager clusterManager) {
        this.config = config;
        this.topic = topic;
        this.txFeedbackCallback = txFeedbackCallback;
        this.messageSender = messageSender;
        this.clusterManager = clusterManager;
    }

    public void dispatch() {
        TopicMetadata topicMetadata = this.clusterManager.fetchTopicMetadata(this.topic, this.config.getApp());
        if (topicMetadata == null) {
            logger.warn("topic {} not exist", (Object)this.topic);
            return;
        }
        for (BrokerNode brokerNode : topicMetadata.getBrokers()) {
            this.doFeedback(topicMetadata, brokerNode);
        }
    }

    protected void doFeedback(TopicMetadata topicMetadata, BrokerNode brokerNode) {
        FetchFeedbackData fetchFeedbackData = null;
        try {
            fetchFeedbackData = this.messageSender.fetchFeedback(brokerNode, this.topic, this.config.getApp(), TxStatus.UNKNOWN, this.config.getFetchSize(), this.config.getLongPollTimeout(), this.config.getTimeout());
            if (!fetchFeedbackData.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                logger.error("fetch feedback error, topic: {}, error: {}", (Object)this.topic, (Object)fetchFeedbackData.getCode().getMessage(new Object[0]));
                return;
            }
        }
        catch (Exception e) {
            logger.error("fetch feedback exception, topic: {}", (Object)this.topic, (Object)e);
            return;
        }
        if (CollectionUtils.isEmpty(fetchFeedbackData.getData())) {
            logger.debug("fetch feedback is empty, topic: {}", (Object)this.topic);
            return;
        }
        for (FeedbackData feedbackData : fetchFeedbackData.getData()) {
            this.doConfirm(brokerNode, topicMetadata, feedbackData);
        }
    }

    protected void doConfirm(BrokerNode brokerNode, TopicMetadata topicMetadata, FeedbackData feedbackData) {
        TopicName topicName = TopicName.parse((String)topicMetadata.getTopic());
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.txFeedbackCallback.confirm(topicName, feedbackData.getTxId(), feedbackData.getTransactionId());
            if (transactionStatus == null) {
                logger.warn("confirm feedback error, status is null, topic: {}, transactionId: {}", (Object)this.topic, (Object)feedbackData.getTransactionId());
                return;
            }
        }
        catch (Exception e) {
            logger.error("confirm feedback exception, topic: {}, transactionId: {}", new Object[]{this.topic, feedbackData.getTransactionId(), e});
            return;
        }
        try {
            if (transactionStatus.equals((Object)TransactionStatus.PREPARE)) {
                logger.debug("commit transaction, status: {}, txId: {}, transactionId: {}", new Object[]{transactionStatus, feedbackData.getTxId(), feedbackData.getTransactionId()});
                this.messageSender.commit(brokerNode, this.topic, this.config.getApp(), feedbackData.getTxId(), this.config.getTimeout());
            } else if (transactionStatus.equals((Object)TransactionStatus.COMMITTED)) {
                logger.debug("rollback transaction, status: {}, txId: {}, transactionId: {}", new Object[]{transactionStatus, feedbackData.getTxId(), feedbackData.getTransactionId()});
                this.messageSender.rollback(brokerNode, this.topic, this.config.getApp(), feedbackData.getTxId(), this.config.getTimeout());
            } else if (transactionStatus.equals((Object)TransactionStatus.ROLLBACK)) {
                logger.debug("rollback transaction, status: {}, txId: {}, transactionId: {}", new Object[]{transactionStatus, feedbackData.getTxId(), feedbackData.getTransactionId()});
                this.messageSender.rollback(brokerNode, this.topic, this.config.getApp(), feedbackData.getTxId(), this.config.getTimeout());
            }
        }
        catch (Exception e) {
            logger.error("commit feedback exception, topic: {}, transactionId: {}", new Object[]{this.topic, feedbackData.getTransactionId(), e});
        }
    }
}

