/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.feedback;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.callback.TxFeedbackCallback;
import org.joyqueue.client.internal.producer.feedback.TxFeedbackDispatcher;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxFeedbackScheduler
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TxFeedbackScheduler.class);
    private TxFeedbackConfig config;
    private String topic;
    private TxFeedbackCallback txFeedbackCallback;
    private MessageSender messageSender;
    private ClusterManager clusterManager;
    private TxFeedbackDispatcher feedbackDispatcher;
    private ScheduledExecutorService scheduleThreadPool;

    public TxFeedbackScheduler(TxFeedbackConfig config, String topic, TxFeedbackCallback txFeedbackCallback, MessageSender messageSender, ClusterManager clusterManager) {
        this.config = config;
        this.topic = topic;
        this.txFeedbackCallback = txFeedbackCallback;
        this.messageSender = messageSender;
        this.clusterManager = clusterManager;
    }

    protected void validate() throws Exception {
        this.feedbackDispatcher = new TxFeedbackDispatcher(this.config, this.topic, this.txFeedbackCallback, this.messageSender, this.clusterManager);
        this.scheduleThreadPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(String.format("joyqueue-txFeedback-scheduler-%s", this.topic), true));
    }

    protected void doStart() throws Exception {
        this.scheduleThreadPool.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TxFeedbackScheduler.this.feedbackDispatcher.dispatch();
            }
        }, this.config.getFetchInterval(), this.config.getFetchInterval(), TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        if (this.scheduleThreadPool != null) {
            this.scheduleThreadPool.shutdown();
        }
        logger.info("{} feedback is stopped", (Object)this.topic);
    }
}

