/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.producer.PartitionSelector;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public class ProducerHelper {
    public static void setPartitions(List<ProduceMessage> messages, short partition) {
        for (ProduceMessage message : messages) {
            message.setPartition(partition);
        }
    }

    public static void clearPartitions(List<ProduceMessage> messages) {
        for (ProduceMessage message : messages) {
            ProducerHelper.clearPartition(message);
        }
    }

    public static void clearPartition(ProduceMessage message) {
        message.setPartition((short)Short.MIN_VALUE);
        message.setPartitionKey(ProduceMessage.NONE_PARTITION_KEY);
    }

    public static PartitionMetadata dispatchPartitions(List<ProduceMessage> messages, TopicMetadata topicMetadata, List<PartitionMetadata> partitions, PartitionSelector partitionSelector) {
        return partitionSelector.select(messages.get(0), topicMetadata, partitions);
    }

    public static List<PartitionMetadata> filterBlackList(List<PartitionMetadata> partitions, List<PartitionMetadata> blackPartitionList) {
        ArrayList newPartitions = Lists.newArrayList(partitions);
        Iterator newPartitionIterator = newPartitions.iterator();
        block0: while (newPartitionIterator.hasNext()) {
            PartitionMetadata newPartition = (PartitionMetadata)newPartitionIterator.next();
            for (PartitionMetadata blackPartition : blackPartitionList) {
                if (blackPartition.getPartitionGroupId() != newPartition.getPartitionGroupId()) continue;
                newPartitionIterator.remove();
                continue block0;
            }
        }
        return newPartitions;
    }
}

