/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.interceptor;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public class ProduceContext {
    private String topic;
    private String app;
    private NameServerConfig nameserver;
    private List<ProduceMessage> messages;
    private Map<Object, Object> attributes;

    public ProduceContext(String topic, String app, NameServerConfig nameserver, List<ProduceMessage> messages) {
        this.topic = topic;
        this.app = app;
        this.nameserver = nameserver;
        this.messages = messages;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public NameServerConfig getNameserver() {
        return this.nameserver;
    }

    public List<ProduceMessage> getMessages() {
        return this.messages;
    }

    public <T> T getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return (T)this.attributes.get(key);
    }

    public boolean removeAttribute(Object key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.remove(key) != null;
    }

    public boolean putAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        return this.attributes.put(key, value) == null;
    }

    public boolean containsAttribute(Object key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(key);
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }
}

