/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.interceptor;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.client.internal.common.ordered.OrderedSorter;
import org.joyqueue.client.internal.producer.interceptor.GlobalProducerInterceptorManager;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptor;

public class ProducerInterceptorManager {
    private List<ProducerInterceptor> interceptors = Lists.newLinkedList();
    private List<ProducerInterceptor> sortedInterceptors;

    public List<ProducerInterceptor> getSortedInterceptors() {
        if (this.sortedInterceptors != null) {
            return this.sortedInterceptors;
        }
        LinkedList sortedInterceptors = Lists.newLinkedList();
        sortedInterceptors.addAll(GlobalProducerInterceptorManager.getInterceptors());
        sortedInterceptors.addAll(this.interceptors);
        OrderedSorter.sort(sortedInterceptors);
        this.sortedInterceptors = sortedInterceptors;
        return sortedInterceptors;
    }

    public void addInterceptor(ProducerInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.sortedInterceptors = null;
    }

    public void removeInterceptor(ProducerInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.sortedInterceptors = null;
    }
}

