/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.interceptor;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.client.internal.producer.interceptor.ProduceContext;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptor;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptorManager;
import org.joyqueue.client.internal.producer.interceptor.ProducerInvoker;

public class ProducerInvocation {
    private ProducerConfig config;
    private NameServerConfig nameServerConfig;
    private TopicMetadata topicMetadata;
    private List<ProduceMessage> messages;
    private ProducerInterceptorManager producerInterceptorManager;
    private ProducerInvoker producerInvoker;

    public ProducerInvocation(ProducerConfig config, NameServerConfig nameServerConfig, TopicMetadata topicMetadata, List<ProduceMessage> messages, ProducerInterceptorManager producerInterceptorManager, ProducerInvoker producerInvoker) {
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.topicMetadata = topicMetadata;
        this.messages = messages;
        this.producerInterceptorManager = producerInterceptorManager;
        this.producerInvoker = producerInvoker;
    }

    public List<SendResult> invoke() {
        ProduceContext context = new ProduceContext(this.topicMetadata.getTopic(), this.config.getApp(), this.nameServerConfig, Collections.unmodifiableList(this.messages));
        List<ProducerInterceptor> interceptors = this.producerInterceptorManager.getSortedInterceptors();
        if (CollectionUtils.isEmpty(interceptors)) {
            return this.producerInvoker.invoke(context);
        }
        boolean isRejected = false;
        for (ProducerInterceptor interceptor : interceptors) {
            if (interceptor.preSend(context)) continue;
            isRejected = true;
        }
        if (isRejected) {
            return this.producerInvoker.reject(context);
        }
        List<SendResult> result = this.producerInvoker.invoke(context);
        for (ProducerInterceptor interceptor : interceptors) {
            interceptor.postSend(context, result);
        }
        return result;
    }
}

