/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.support;

import java.util.List;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.producer.PartitionSelector;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public abstract class AbstractPartitionSelector
implements PartitionSelector {
    @Override
    public PartitionMetadata select(ProduceMessage message, TopicMetadata topicMetadata, List<PartitionMetadata> partitions) {
        if (message.getPartition() != Short.MIN_VALUE) {
            return this.selectPartition(message, topicMetadata, partitions);
        }
        if (message.getPartitionKey() != ProduceMessage.NONE_PARTITION_KEY) {
            return this.hashPartition(message, topicMetadata, partitions);
        }
        return this.nextPartition(message, topicMetadata, partitions);
    }

    protected PartitionMetadata selectPartition(ProduceMessage message, TopicMetadata topicMetadata, List<PartitionMetadata> partitions) {
        for (PartitionMetadata partition : partitions) {
            if (message.getPartition() != partition.getId()) continue;
            return partition;
        }
        return null;
    }

    protected PartitionMetadata hashPartition(ProduceMessage message, TopicMetadata topicMetadata, List<PartitionMetadata> partitions) {
        return partitions.get(Math.abs(message.getPartitionKey().hashCode() % partitions.size()));
    }

    protected abstract PartitionMetadata nextPartition(ProduceMessage var1, TopicMetadata var2, List<PartitionMetadata> var3);
}

