/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.support;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.TransactionMessageProducer;
import org.joyqueue.client.internal.producer.callback.AsyncBatchProduceCallback;
import org.joyqueue.client.internal.producer.callback.AsyncProduceCallback;
import org.joyqueue.client.internal.producer.callback.CompletableFutureAsyncBatchProduceCallback;
import org.joyqueue.client.internal.producer.callback.CompletableFutureAsyncProduceCallback;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.config.SenderConfig;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.client.internal.producer.exception.ProducerException;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptor;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptorManager;
import org.joyqueue.client.internal.producer.support.DefaultMessageSender;
import org.joyqueue.client.internal.producer.support.DefaultTransactionMessageProducer;
import org.joyqueue.client.internal.producer.support.MessageProducerInner;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageProducer
extends Service
implements MessageProducer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMessageProducer.class);
    private ProducerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ProducerClientManager producerClientManager;
    private SenderConfig senderConfig;
    private MessageSender messageSender;
    private AtomicLong transactionSequence;
    private MessageProducerInner messageProducerInner;
    private ProducerInterceptorManager producerInterceptorManager = new ProducerInterceptorManager();

    public DefaultMessageProducer(ProducerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ProducerClientManager producerClientManager) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"producer not null");
        Preconditions.checkArgument((nameServerConfig != null ? 1 : 0) != 0, (Object)"nameServer not null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager not null");
        Preconditions.checkArgument((producerClientManager != null ? 1 : 0) != 0, (Object)"producerClientManager not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getApp()), (Object)"producer.app not blank");
        Preconditions.checkArgument((config.getRetryPolicy() != null ? 1 : 0) != 0, (Object)"producer.retryPolicy not null");
        Preconditions.checkArgument((config.getQosLevel() != null ? 1 : 0) != 0, (Object)"producer.qosLevel not null");
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.producerClientManager = producerClientManager;
    }

    protected void validate() throws Exception {
        this.transactionSequence = new AtomicLong();
        this.senderConfig = new SenderConfig(this.config.isCompress(), this.config.getCompressThreshold(), this.config.getCompressType(), this.config.isBatch());
        this.messageSender = new DefaultMessageSender(this.producerClientManager, this.senderConfig);
        this.messageProducerInner = new MessageProducerInner(this.config, this.nameServerConfig, this.messageSender, this.clusterManager, this.producerClientManager, this.producerInterceptorManager);
    }

    protected void doStart() throws Exception {
        this.messageSender.start();
        this.messageProducerInner.start();
    }

    protected void doStop() {
        if (this.messageProducerInner != null) {
            this.messageProducerInner.stop();
        }
        if (this.messageSender != null) {
            this.messageSender.stop();
        }
    }

    @Override
    public SendResult send(ProduceMessage message) {
        return this.send(message, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public SendResult send(ProduceMessage message, long timeout, TimeUnit timeoutUnit) {
        return this.doSend(message, timeout, timeoutUnit, false, null);
    }

    @Override
    public List<SendResult> batchSend(List<ProduceMessage> messages) {
        return this.batchSend(messages, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<SendResult> batchSend(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        return this.doBatchSend(messages, timeout, timeoutUnit, false, null);
    }

    @Override
    public void sendOneway(ProduceMessage message) {
        this.sendOneway(message, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void sendOneway(ProduceMessage message, long timeout, TimeUnit timeoutUnit) {
        this.doSend(message, timeout, timeoutUnit, true, null);
    }

    @Override
    public void batchSendOneway(List<ProduceMessage> messages) {
        this.batchSendOneway(messages, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void batchSendOneway(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        this.doBatchSend(messages, timeout, timeoutUnit, true, null);
    }

    @Override
    public CompletableFuture<SendResult> sendAsync(ProduceMessage message) {
        return this.sendAsync(message, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<SendResult> sendAsync(ProduceMessage message, long timeout, TimeUnit timeoutUnit) {
        CompletableFuture<SendResult> future = new CompletableFuture<SendResult>();
        this.doSend(message, timeout, timeoutUnit, false, new CompletableFutureAsyncProduceCallback(future));
        return future;
    }

    @Override
    public CompletableFuture<List<SendResult>> batchSendAsync(List<ProduceMessage> messages) {
        return this.batchSendAsync(messages, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<List<SendResult>> batchSendAsync(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        CompletableFuture<List<SendResult>> future = new CompletableFuture<List<SendResult>>();
        this.doBatchSend(messages, timeout, timeoutUnit, false, new CompletableFutureAsyncBatchProduceCallback(future));
        return future;
    }

    protected SendResult doSend(ProduceMessage message, long timeout, TimeUnit timeoutUnit, boolean isOneway, AsyncProduceCallback callback) {
        this.checkState();
        return this.messageProducerInner.send(message, null, timeout, timeoutUnit, isOneway, this.config.isFailover(), callback);
    }

    protected List<SendResult> doBatchSend(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit, boolean isOneway, AsyncBatchProduceCallback callback) {
        this.checkState();
        return this.messageProducerInner.batchSend(messages, null, timeout, timeoutUnit, isOneway, this.config.isFailover(), callback);
    }

    @Override
    public TransactionMessageProducer beginTransaction() {
        return this.beginTransaction(this.config.getTransactionTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public TransactionMessageProducer beginTransaction(long timeout, TimeUnit timeoutUnit) {
        return new DefaultTransactionMessageProducer(null, timeout, timeoutUnit, this.transactionSequence.getAndIncrement(), this.config, this.nameServerConfig, this.clusterManager, this.messageSender, this.messageProducerInner);
    }

    @Override
    public TransactionMessageProducer beginTransaction(String transactionId) {
        return this.beginTransaction(transactionId, this.config.getTransactionTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public TransactionMessageProducer beginTransaction(String transactionId, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)transactionId), (Object)"transactionId not blank");
        return new DefaultTransactionMessageProducer(transactionId, timeout, timeoutUnit, this.transactionSequence.getAndIncrement(), this.config, this.nameServerConfig, this.clusterManager, this.messageSender, this.messageProducerInner);
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        this.checkState();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        String topicFullName = this.messageProducerInner.getTopicFullName(topic);
        return this.clusterManager.fetchTopicMetadata(topicFullName, this.config.getApp());
    }

    @Override
    public synchronized void addInterceptor(ProducerInterceptor interceptor) {
        Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
        this.producerInterceptorManager.addInterceptor(interceptor);
    }

    @Override
    public synchronized void removeInterceptor(ProducerInterceptor interceptor) {
        Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
        this.producerInterceptorManager.removeInterceptor(interceptor);
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new ProducerException("producer is not started", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }
}

